/*
This is a program to extract the files from the floppy disc
image floppy.img

Written by Martin Richards (c) 9 Jan 2017
*/

GET "libhdr"

GLOBAL {
  stdin:ug
  stdout
  filename
  filestream
  filecount
  sectnumber
  sectcount
  bootoption
}

LET start()= VALOF
{ LET sect0 = VEC 256/bytesperword
  LET sect1 = VEC 256/bytesperword
  LET sectn = VEC 256/bytesperword // To hold sector sectnumber

  stdin := input()
  stdout := output()

  filename := "floppy.img"
  filestream := findinput(filename)

  UNLESS filestream DO
  { writef("Cannot open file %s*n", filename)
    GOTO fin
  }

  setrecordlength(filestream, 256)

  UNLESS get_record(sect0, 0, filestream) DO
  { writef("Unable to get record 0 of %s*n", filename)
    GOTO fin
  }

  UNLESS get_record(sect1, 1, filestream) DO
  { writef("Unable to get record 0 of %s*n", filename)
    GOTO fin
  }

  //writef("*nSector 0*n")
  //FOR i = 0 TO 255 DO
  //{ IF i MOD 16 = 0 DO writef("*n%i3: ", i)
  //  writef(" %x2", sect0%i)
  //} 

  //newline()

  //writef("*nSector 1*n")
  //FOR i = 0 TO 255 DO
  //{ IF i MOD 16 = 0 DO writef("*n%i3: ", i)
  //  writef(" %x2", sect1%i)
  //} 

  //newline()

  filecount := sect1%5 / 8
  sectcount := (sect1%6 & 3)<< 8 | sect1%7
  bootoption := (sect1%6>>4) & 3

  writef("*nDisc title: ")
  FOR i = 0 TO 7 DO         // First 8 characters
  { LET ch = sect0%i
    IF ch=0 BREAK
    wrch(ch)
  }
  FOR i = 0 TO 4 DO         // Last 5 characters
  { LET ch = sect1%i
    IF ch=0 BREAK
    wrch(ch)
  }
  newline()

  writef("*nThere are %n files on the disc*n", filecount)
  writef("Number of sectors %n   Boot option %n*n", sectcount, bootoption)
  newline()

  FOR fno = 1 TO filecount DO
  { LET name = VEC 20/bytesperword
    LET dirname = "FILES"
    LET len = 0
    LET pos = fno * 8     // Position of file entry in sect0 and sect1
    LET firstsector = 0
    LET filelength = 0
    LET loadaddress = 0
    LET execaddress = 0
    LET stream = 0

    FOR i = 1 TO dirname%0 DO   // Directory name
    { len := len+1
      name%len := dirname%i
    }

    len := len+1                // Separator
    name%len := '/'

    FOR  i = pos TO pos+6 DO    // File name
    { LET ch = sect0%i
      IF ch=0 | ch='*s' BREAK
      len := len+1
      name%len := ch
    }
    name%0 := len

    //writef("*nExtracted file name: ")
    //FOR i = 0 TO len DO writef(" %x2", name%i)
    //newline()

    firstsector := ( sect1%(pos+6)    &3)<< 8 | sect1%(pos+7)
    filelength  := ((sect1%(pos+6)>>4)&3)<<16 | sect1%(pos+5)<<8 | sect1%(pos+4)
    loadaddress := ((sect1%(pos+6)>>2)&3)<<16 | sect1%(pos+1)<<8 | sect1%(pos+0)
    execaddress := ((sect1%(pos+6)>>6)&3)<<16 | sect1%(pos+3)<<8 | sect1%(pos+2)

    //FOR i = pos+0 TO pos+7 DO writef(" %x2", sect1%i)
    //newline()
    writef("%i2: %14t  dir %c  sector %i3 length %i5 load %i6 exec %i6*n",
            fno, name, sect0%(pos+7), firstsector, filelength, loadaddress, execaddress)


    stream := findoutput(name)
    UNLESS stream DO
    { writef("Unable to open file %s*n", name)
      GOTO fin
    }

    //writef("*nFile %s opened for output*n", name)
    //abort(1001)
    selectoutput(stream)

    sectnumber := -1

    FOR i = 0 TO filelength-1 DO
    { LET n = firstsector + i / 256
      LET offset = i MOD 256
      UNLESS n=sectnumber DO
      { sectnumber := n
        //writef("*nReading sector %n*n", sectnumber)
        UNLESS get_record(sectn, sectnumber, filestream) DO
        { sawritef("Unable to read sector %n of %s*n", sectnumber, filename)
          endstream(stream)
          GOTO fin
        }
      }
      //IF i MOD 16 = 0 DO writef("*n%i2 %i5: ", sectnumber, i)
      //IF i MOD 2 = 0 DO wrch(' ')
      //writef(" %x2", sectn%(offset XOR 1))
      binwrch(sectn%(offset))
    }
    endstream(stream)
    selectoutput(stdout)
    //newline()
//abort(1000)
  }

fin:
  IF filestream DO endstream(filestream)
  result2 := 0
  RESULTIS 0
}
