// This section compiles correctly.

//SECTION "BLIB2"
//37136: 03E8 BCPL  Section     size   136 bytes

GET "com16/LIBHDR.h"
GET "com16/SYSHDR.h"

LET COWAIT(a) = VALOF
{ // 37142.
  LET parent = CURRCO!co.parent
  CURRCO!co.parent := 0
  CURRCO := parent
  RESULTIS CHANGECO(a, parent)
}

AND CREATECO(fn, size) = VALOF
{ // 37158.
  LET c = GETVEC(size)   // p5
  // 37162.
  UNLESS c RESULTIS 0
  // 37167.

  // Using P to denote the current stack frame
  // pointer, the following assumptions are made:
  //  P!0, P!1, P!2 contain the return link information
  //  P!3   is the variable fn
  //  P!4   is the variable size
  //  P!5   is the variable c

  // Now make the vector c into a valid BCPL
  // stack frame containg copies of fn, size
  // and c in the same relative positions.
  // Other locations in the new stack frame 
  // are used for other purposes.

  // 37167.
  c!-1 := 2
  c!0 := c+5      // resumption point
  c!1 := CURRCO   // parent link
  c!2 := COLIST   // colist chain
  c!3 := fn       // the main function
  c!4 := size     // the coroutine size
  c!5 := c        // the new coroutine pointer

  CURRCO := c
  COLIST := c  // insert into the list of coroutines

  c!6 := 0               // Clear the rest of the coroutine stack
  MOVE(c+6, c+7, size-7)

  CHANGECO(0, c)

  // Execution now continues with the P pointer set to c<<B2Wsh,
  // and so  the vector c becomes the current stack frame.
  // The compiler will have generated code on
  // the assumption that fn and c are the third and fifth
  // words of the stack frame, and, since c!3 and c!5
  // were initialised to fn and c, the following repeated
  // statement will have the effect (naively) expected.
  // Note that the first call of cowait causes a return
  // from createco with result c.

  c := fn(COWAIT(c)) REPEAT
}

AND DELETECO(cptr) = VALOF
{ // 37226.
  LET a = @COLIST

  // Search for cptr in COLIST
  UNTIL !a=0 | !a=cptr DO
  { // 37231.
    a := !a + 2
  }

  UNLESS !a RESULTIS FALSE

  // 37246.
  IF cptr!co.parent DO
  { // 37249.
    abort(112)
  }

  // 37253.
  !a := cptr!co.list      // Remove the coroutine from colist.
  // 37255.
  FREEVEC(cptr)           // Free the coroutine stack.
  // 37258.
  RESULTIS TRUE           // Successful
}


