; Rijndael assembler code v3.2
;
 
; toestand in de scratch-pad op adres 050H

; round key is kept in the scratch pad area at location 070H
; rcon is in location 04EH 
; ROOT is in reg B

JMP START


SBOX:	
	DB     063H,07cH,077H,07bH,0f2H,06bH,06fH,0c5H,030H,001H,067H,02bH,0feH,0d7H,0abH,076H
	DB     0caH,082H,0c9H,07dH,0faH,059H,047H,0f0H,0adH,0d4H,0a2H,0afH,09cH,0a4H,072H,0c0H
	DB     0b7H,0fdH,093H,026H,036H,03fH,0f7H,0ccH,034H,0a5H,0e5H,0f1H,071H,0d8H,031H,015H
	DB     004H,0c7H,023H,0c3H,018H,096H,005H,09aH,007H,012H,080H,0e2H,0ebH,027H,0b2H,075H
	DB     009H,083H,02cH,01aH,01bH,06eH,05aH,0a0H,052H,03bH,0d6H,0b3H,029H,0e3H,02fH,084H
	DB     053H,0d1H,000H,0edH,020H,0fcH,0b1H,05bH,06aH,0cbH,0beH,039H,04aH,04cH,058H,0cfH
	DB     0d0H,0efH,0aaH,0fbH,043H,04dH,033H,085H,045H,0f9H,002H,07fH,050H,03cH,09fH,0a8H
	DB     051H,0a3H,040H,08fH,092H,09dH,038H,0f5H,0bcH,0b6H,0daH,021H,010H,0ffH,0f3H,0d2H
	DB     0cdH,00cH,013H,0ecH,05fH,097H,044H,017H,0c4H,0a7H,07eH,03dH,064H,05dH,019H,073H
	DB     060H,081H,04fH,0dcH,022H,02aH,090H,088H,046H,0eeH,0b8H,014H,0deH,05eH,00bH,0dbH
	DB     0e0H,032H,03aH,00aH,049H,006H,024H,05cH,0c2H,0d3H,0acH,062H,091H,095H,0e4H,079H
	DB     0e7H,0c8H,037H,06dH,08dH,0d5H,04eH,0a9H,06cH,056H,0f4H,0eaH,065H,07aH,0aeH,008H
	DB     0baH,078H,025H,02eH,01cH,0a6H,0b4H,0c6H,0e8H,0ddH,074H,01fH,04bH,0bdH,08bH,08aH
	DB     070H,03eH,0b5H,066H,048H,003H,0f6H,00eH,061H,035H,057H,0b9H,086H,0c1H,01dH,09eH
	DB     0e1H,0f8H,098H,011H,069H,0d9H,08eH,094H,09bH,01eH,087H,0e9H,0ceH,055H,028H,0dfH
	DB     08cH,0a1H,089H,00dH,0bfH,0e6H,042H,068H,041H,099H,02dH,00fH,0b0H,054H,0bbH,016H

SIGAPI:
; implements sigma, gamma, pi 
	MOV	A,050H
	XRL	A,070H
	MOVC	A,@A+DPTR
	MOV	050H,A	
	MOV	A,054H
	XRL	A,074H
	MOVC	A,@A+DPTR
	MOV	054H,A	
	MOV	A,058H
	XRL	A,078H
	MOVC	A,@A+DPTR
	MOV	058H,A	
	MOV	A,05CH
	XRL	A,07CH
	MOVC	A,@A+DPTR
	MOV	05CH,A	
	
	MOV	A,051H
	XRL	A,071H
	MOVC	A,@A+DPTR
	XCH	A,05DH	
	XRL	A,07DH
	MOVC	A,@A+DPTR
	XCH	A,059H	
	XRL	A,079H
	MOVC	A,@A+DPTR
	XCH	A,055H	
	XRL	A,075H
	MOVC	A,@A+DPTR
	MOV	051H,A	
	
	MOV	A,053H
	XRL	A,073H
	MOVC	A,@A+DPTR
	XCH	A,057H	
	XRL	A,077H
	MOVC	A,@A+DPTR
	XCH	A,05BH	
	XRL	A,07BH
	MOVC	A,@A+DPTR
	XCH	A,05FH	
	XRL	A,07FH
	MOVC	A,@A+DPTR
	MOV	053H,A	
	
	MOV	A,052H
	XRL	A,072H
	MOVC	A,@A+DPTR
	XCH	A,05AH	
	XRL	A,07AH
	MOVC	A,@A+DPTR
	MOV	052H,A
	MOV	A,056H
	XRL	A,076H
	MOVC	A,@A+DPTR
	XCH	A,05EH	
	XRL	A,07EH
	MOVC	A,@A+DPTR
	MOV	056H,A
	
	RET
	


; spend time to thwart timing attacks
J0:     SJMP    JJ0


THETA:
; first calculate 2*a	
	
        MOV     R0,#050H
        MOV     R1,#060H
S2:
        MOV     A,@R0
        RL      A
        JNB     ACC.0,J0
        XRL     A,B
        NOP
JJ0:    MOV     @R1,A

        INC     R0
        INC     R1
        CJNE    R0,#060H,S2
	
	
; now calculate theta
; 1ste kolom	
; exor of the four entries
	MOV	A,050H
	XRL	A,051H
	XRL	A,052H
	XRL	A,053H
	MOV	R3,A
	
	XRL	A,060H
	XRL	A,061H
	XRL	050H,A
	
	MOV	A,R3
	XRL	A,061H
	XRL	A,062H
	XRL	051H,A

	MOV	A,R3
	XRL	A,062H
	XRL	A,063H
	XRL	052H,A

	MOV	A,R3
	XRL	A,063H
	XRL	A,060H
	XRL	053H,A

; 2de kolom	
	MOV	A,054H
	XRL	A,055H
	XRL	A,056H
	XRL	A,057H
	MOV	R3,A
	
	XRL	A,064H
	XRL	A,065H
	XRL	054H,A
	
	MOV	A,R3
	XRL	A,065H
	XRL	A,066H
	XRL	055H,A

	MOV	A,R3
	XRL	A,066H
	XRL	A,067H
	XRL	056H,A

	MOV	A,R3
	XRL	A,067H
	XRL	A,064H
	XRL	057H,A

; 3de kolom	
	MOV	A,058H
	XRL	A,059H
	XRL	A,05AH
	XRL	A,05BH
	MOV	R3,A
	
	XRL	A,068H
	XRL	A,069H
	XRL	058H,A
	
	MOV	A,R3
	XRL	A,069H
	XRL	A,06AH
	XRL	059H,A

	MOV	A,R3
	XRL	A,06AH
	XRL	A,06BH
	XRL	05AH,A

	MOV	A,R3
	XRL	A,06BH
	XRL	A,068H
	XRL	05BH,A

; 4de kolom	
	MOV	A,05CH
	XRL	A,05DH
	XRL	A,05EH
	XRL	A,05FH
	MOV	R3,A
	
	XRL	A,06CH
	XRL	A,06DH
	XRL	05CH,A
	
	MOV	A,R3
	XRL	A,06DH
	XRL	A,06EH
	XRL	05DH,A

	MOV	A,R3
	XRL	A,06EH
	XRL	A,06FH
	XRL	05EH,A

	MOV	A,R3
	XRL	A,06FH
	XRL	A,06CH
	XRL	05FH,A

;	RET
;PHI:
; calculate new round key
	MOV	04FH,07CH

	MOV	A,07DH	
	MOVC	A,@A+DPTR
	XRL	A,070H
; rcon	
	XRL	A,04EH 
	MOV	070H,A
	XRL	A,074H
	MOV	074H,A
	XRL	A,078H
	MOV	078H,A
	XRL	A,07CH
	MOV	07CH,A

	MOV	A,07EH	
	MOVC	A,@A+DPTR
	XRL	A,071H
	MOV	071H,A
	XRL	A,075H
	MOV	075H,A
	XRL	A,079H
	MOV	079H,A
	XRL	A,07DH
	MOV	07DH,A

	MOV	A,07FH	
	MOVC	A,@A+DPTR
	XRL	A,072H
	MOV	072H,A
	XRL	A,076H
	MOV	076H,A
	XRL	A,07AH
	MOV	07AH,A
	XRL	A,07EH
	MOV	07EH,A

	MOV	A,04FH	
	MOVC	A,@A+DPTR
	XRL	A,073H
	MOV	073H,A
	XRL	A,077H
	MOV	077H,A
	XRL	A,07BH
	MOV	07BH,A
	XRL	A,07FH
	MOV	07FH,A
; new rcon
	
	MOV	A,04EH
	RL	A
	JNB	ACC.0,J10
	XRL	A,B
J10:	MOV	04EH,A

	RET



ROUND:
	CALL	SIGAPI
	CALL	THETA
;	CALL	PHI
	RET	

	
START:
	MOV	070H,#00H
	MOV	071H,#00H
	MOV	072H,#00H
	MOV	073H,#00H
	MOV	074H,#00H
	MOV	075H,#00H
	MOV	076H,#00H
	MOV	077H,#00H
	MOV	078H,#00H
	MOV	079H,#00H
	MOV	07AH,#00H
	MOV	07BH,#00H
	MOV	07CH,#00H
	MOV	07DH,#00H
	MOV	07EH,#00H
	MOV	07FH,#00H
	
	MOV	050H,#00H
	MOV	051H,#00H
	MOV	052H,#00H
	MOV	053H,#00H
	MOV	054H,#00H
	MOV	055H,#00H
	MOV	056H,#00H
	MOV	057H,#00H
	MOV	058H,#00H
	MOV	059H,#00H
	MOV	05AH,#00H
	MOV	05BH,#00H
	MOV	05CH,#00H
	MOV	05DH,#00H
	MOV	05EH,#00H
	MOV	05FH,#00H
	

	MOV	SP,#030H
	MOV	DPTR,#SBOX
	MOV	B,#01AH
	MOV	04EH,#01H

	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	ROUND
	CALL	SIGAPI

; final phi and sigma

	MOV	04FH,07CH

	MOV	A,07DH	
	MOVC	A,@A+DPTR
	XRL	A,070H
; rcon	
	XRL	A,04EH 
	XRL	050H,A
	XRL	A,074H
	XRL	054H,A
	XRL	A,078H
	XRL	058H,A
	XRL	A,07CH
	XRL	05CH,A

	MOV	A,07EH	
	MOVC	A,@A+DPTR
	XRL	A,071H
	XRL	051H,A
	XRL	A,075H
	XRL	055H,A
	XRL	A,079H
	XRL	059H,A
	XRL	A,07DH
	XRL	05DH,A

	MOV	A,07FH	
	MOVC	A,@A+DPTR
	XRL	A,072H
	XRL	052H,A
	XRL	A,076H
	XRL	056H,A
	XRL	A,07AH
	XRL	05AH,A
	XRL	A,07EH
	XRL	05EH,A

	MOV	A,04FH	
	MOVC	A,@A+DPTR
	XRL	A,073H
	XRL	053H,A
	XRL	A,077H
	XRL	057H,A
	XRL	A,07BH
	XRL	05BH,A
	XRL	A,07FH
	XRL	05FH,A


	END


