
$x_pixels = 512;
$y_pixels = 304;
$colors = 3;


sub build_query {
        local($x1, $x2, $y) = @_;
        local($query, $x);

        $query = ":display:pixel? $x1, $y";
        for ($x = $x1 + 1; $x < $x2; $x++) {
                $query .= "; pixel? $x, $y";
        }

        return($query);
}

sub save_screen {
        local($data = [[]]);
        local($x, $y);
        local($bytes, $response);
        local($query);
        local($chunksize) = 16;
        local($chunkcount);
        local(@readdata);

        for ($y = 0; $y < $y_pixels; $y++) {
                for ($chunk = 0; $chunk < ($x_pixels / $chunksize);
                    $chunk++) {
                        $query = build_query($chunk * $chunksize,
                            ($chunk + 1) * $chunksize, $y);
                        osc_write($query) || die "osc_write: $!";
                        (($bytes, $response) = osc_read()) ||
                            die "osc_read: $!";
                        @readdata = split(/;/, $response);
                        for ($x = $chunk * $chunksize; $x <
                            ($chunk + 1) * $chunksize; $x++) {
                                $data[$x][$y] = $readdata[$x -
                                    ($chunk * $chunksize)];
                        }
                }
        }
        return($data);
}

sub restore_screen {
        local($data) = shift(@_);
        local($query);

        for ($x = 0; $x < $x_pixels; $x++) {
                for($y = 0; $y < $y_pixels; $y += 2) {
                        osc_write(":display:pixel $x, $y, ".$data[$x][$y].
                            "; pixel $x, ".($y+1).", ".$data[$x][$y+1]) ||
                            die "osc_write: $!";
                }
        }
}



return 1;
