(*  Title:      Terms.thy
    ID:         $Id: Terms.thy,v 1.6 1998/12/28 15:54:19 paulson Exp $
    Author:     Ole Rasmussen
    Copyright   1995  University of Cambridge
    Logic Image: ZF
*)

Terms = Cube+

consts
  lambda        :: i
  unmark        :: i=>i
  Apl           :: [i,i]=>i

translations
  "Apl(n,m)" == "App(0,n,m)"
  
inductive
  domains       "lambda" <= "redexes"
  intrs
    Lambda_Var  "               n:nat ==>     Var(n):lambda"
    Lambda_Fun  "            u:lambda ==>     Fun(u):lambda"
    Lambda_App  "[|u:lambda; v:lambda|]==> Apl(u,v):lambda"
  type_intrs    "redexes.intrs@bool_typechecks"

primrec
  "unmark(Var(n)) = Var(n)"
  "unmark(Fun(u)) = Fun(unmark(u))"
  "unmark(App(b,f,a)) = Apl(unmark(f), unmark(a))"

end


