(*  Title:      Pure/pure.ML
    ID:         $Id: pure.ML,v 1.16 2000/05/24 17:09:38 wenzelm Exp $
    Author:     Markus Wenzel, TU Muenchen

Final setup of the Pure theories.
*)

local
  val common_setup =
    Locale.setup @
    HTML.setup @
    ProofContext.setup @
    Attrib.setup @
    Method.setup @
    Calculation.setup @
    SkipProof.setup @
    AxClass.setup @
    Latex.setup @
    Present.setup @
    Isamode.setup @
    ProofGeneral.setup;
in
  structure Pure =
  struct
    val thy =
      PureThy.begin_theory "Pure" [ProtoPure.thy]
      |> Theory.add_syntax Syntax.pure_appl_syntax
      |> Library.apply common_setup
      |> PureThy.end_theory;
  end;

  structure CPure =
  struct
    val thy =
      PureThy.begin_theory "CPure" [ProtoPure.thy]
      |> Theory.add_syntax Syntax.pure_applC_syntax
      |> Library.apply common_setup
      |> Theory.copy
      |> PureThy.end_theory;
  end;
end;

ThyInfo.register_theory ProtoPure.thy;
ThyInfo.register_theory Pure.thy;
ThyInfo.register_theory CPure.thy;
