(*  Title: 	HOLCF/sprod3.thy
    ID:         Sprod3.thy,v 1.2 1994/06/29 10:06:14 clasohm Exp
    Author: 	Franz Regensburger
    Copyright   1993 Technische Universitaet Muenchen

Class instance of  ** for class pcpo
*)

Sprod3 = Sprod2 +

arities "**" :: (pcpo,pcpo)pcpo			(* Witness sprod2.ML *)

consts  
	"@spair"     :: "'a => 'b => ('a**'b)" ("_##_" [101,100] 100)
	"cop @spair" :: "'a -> 'b -> ('a**'b)" ("spair")
					(* continuous strict pairing *)
	sfst         :: "('a**'b)->'a"
	ssnd         :: "('a**'b)->'b"
	ssplit       :: "('a->'b->'c)->('a**'b)->'c"

rules 

inst_sprod_pcpo	"(UU::'a**'b) = Ispair(UU,UU)"
spair_def	"spair  == (LAM x y.Ispair(x,y))"
sfst_def	"sfst   == (LAM p.Isfst(p))"
ssnd_def	"ssnd   == (LAM p.Issnd(p))"	
ssplit_def	"ssplit == (LAM f. strictify[LAM p.f[sfst[p]][ssnd[p]]])"

end

ML

(* ----------------------------------------------------------------------*)
(* parse translations for the above mixfix                               *)
(* ----------------------------------------------------------------------*)

val parse_translation = [("@spair",mk_cinfixtr "@spair")];


