(*  Title: 	HOL/Ord.thy
    ID:         Ord.thy,v 1.2 1994/08/19 09:19:14 lcp Exp
    Author: 	Tobias Nipkow, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

The type class for ordered types
*)

Ord = HOL +
classes
  ord < term
consts
  "<", "<="     :: "['a::ord, 'a] => bool"              (infixl 50)
  mono		:: "['a::ord => 'b::ord] => bool"       (*monotonicity*)
  min,max	:: "['a::ord,'a] => 'a"

rules

mono_def  "mono(f)  == (!A B. A <= B --> f(A) <= f(B))"
min_def   "min(a,b) == if(a <= b, a, b)"
max_def   "max(a,b) == if(a <= b, b, a)"

end
