(*  Title:      HOL/cladata.ML
    ID:         $Id: cladata.ML,v 1.1 1996/09/12 08:40:12 paulson Exp $
    Author:     Tobias Nipkow
    Copyright   1996  University of Cambridge

Setting up the classical reasoner 
*)


(** Applying HypsubstFun to generate hyp_subst_tac **)
section "Classical Reasoner";

structure Hypsubst_Data =
  struct
  structure Simplifier = Simplifier
  (*Take apart an equality judgement; otherwise raise Match!*)
  fun dest_eq (Const("Trueprop",_) $ (Const("op =",_)  $ t $ u)) = (t,u);
  val eq_reflection = eq_reflection
  val imp_intr = impI
  val rev_mp = rev_mp
  val subst = subst
  val sym = sym
  end;

structure Hypsubst = HypsubstFun(Hypsubst_Data);
open Hypsubst;

(*** Applying ClassicalFun to create a classical prover ***)
structure Classical_Data = 
  struct
  val sizef     = size_of_thm
  val mp        = mp
  val not_elim  = notE
  val classical = classical
  val hyp_subst_tacs=[hyp_subst_tac]
  end;

structure Classical = ClassicalFun(Classical_Data);
open Classical;

(*Propositional rules*)
val prop_cs = empty_cs addSIs [refl,TrueI,conjI,disjCI,impI,notI,iffI]
                       addSEs [conjE,disjE,impCE,FalseE,iffE];

(*Quantifier rules*)
val HOL_cs = prop_cs addSIs [allI] addIs [exI,ex1I]
                     addSEs [exE,ex1E] addEs [allE];

exception CS_DATA of claset;

let fun merge [] = CS_DATA empty_cs
      | merge cs = let val cs = map (fn CS_DATA x => x) cs;
                   in CS_DATA (foldl merge_cs (hd cs, tl cs)) end;

    fun put (CS_DATA cs) = claset := cs;

    fun get () = CS_DATA (!claset);
in add_thydata "HOL"
     ("claset", ThyMethods {merge = merge, put = put, get = get})
end;

claset := HOL_cs;

