(*  Title:      HOL/AxClasses/Tutorial/Group.thy
    ID:         $Id: Group.thy,v 1.1 1995/09/01 12:28:42 wenzelm Exp $
    Author:     Markus Wenzel, TU Muenchen

Define classes "semigroup", "group", "agroup".
*)

Group = Sigs +

(* semigroups *)

axclass
  semigroup < term
  assoc         "(x <*> y) <*> z = x <*> (y <*> z)"


(* groups *)

axclass
  group < semigroup
  left_unit     "1 <*> x = x"
  left_inv      "inv x <*> x = 1"


(* abelian groups *)

axclass
  agroup < group
  commut        "x <*> y = y <*> x"

end
