val thy = mk_base [Thy "Ord"] "Set2g" true;

structure Set2g =
struct

local
 val parse_ast_translation = [];
 val parse_translation = [];
 val print_translation = [];
 val print_ast_translation = [];
in



val thy = thy

|> add_trfuns
(parse_ast_translation, parse_translation, print_translation, print_ast_translation)

|> add_types
[("set", 1, NoSyn)]

|> add_tyabbrs
[]

|> add_consts
[("Ball", "'a set  ('a  bool)  bool", NoSyn)]

|> add_syntax
[("GBall", "pttrn  'a set  bool  bool", Mixfix ("(3 _  _ ./ _)", [], 10))]

|> add_trrules
[("logic", " x  A . P") <-> ("logic", "Ball A (x. P)")]

|> add_thyname "Set2g";

val _ = store_theory (thy, "Set2g");




end;
end;
