(*  Title:      HOL/Trancl.thy
    ID:         $Id: Trancl.thy,v 1.8 1996/04/04 09:45:04 paulson Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Relfexive and Transitive closure of a relation

rtrancl is reflexive/transitive closure;
trancl  is transitive closure
reflcl  is reflexive closure
*)

Trancl = Lfp + Relation + 

constdefs
  rtrancl :: "('a * 'a)set => ('a * 'a)set"   ("(_^*)" [100] 100)
  "r^*  ==  lfp(%s. id Un (r O s))"

  trancl  :: "('a * 'a)set => ('a * 'a)set"   ("(_^+)" [100] 100)
  "r^+  ==  r O rtrancl(r)"

syntax
  reflcl  :: "('a*'a)set => ('a*'a)set"       ("(_^=)" [100] 100)

translations
  "r^=" == "r Un id"

end
