(*  Title:      Relation.thy
    ID:         $Id: Relation.thy,v 1.4 1996/04/27 10:09:21 nipkow Exp $
    Author:     Riccardo Mattolini, Dip. Sistemi e Informatica
        and     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1994 Universita' di Firenze
    Copyright   1993  University of Cambridge
*)

Relation = Prod +
consts
    id          :: "('a * 'a)set"               (*the identity relation*)
    O           :: "[('b * 'c)set, ('a * 'b)set] => ('a * 'c)set" (infixr 60)
    trans       :: "('a * 'a)set => bool"       (*transitivity predicate*)
    converse    :: "('a*'b) set => ('b*'a) set"
    "^^"        :: "[('a*'b) set,'a set] => 'b set" (infixl 90)
    Domain      :: "('a*'b) set => 'a set"
    Range       :: "('a*'b) set => 'b set"
defs
    id_def      "id == {p. ? x. p = (x,x)}"
    comp_def    "r O s == {(x,z). ? y. (x,y):s & (y,z):r}"
    trans_def     "trans(r) == (!x y z. (x,y):r --> (y,z):r --> (x,z):r)"
    converse_def  "converse(r) == {(y,x). (x,y):r}"
    Domain_def    "Domain(r) == {x. ? y. (x,y):r}"
    Range_def     "Range(r) == Domain(converse(r))"
    Image_def     "r ^^ s == {y. y:Range(r) &  (? x:s. (x,y):r)}"
end
