(*  Title: 	ZF/rules
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Rules for Zermelo-Fraenkel Set Theory 

!!!After updating, rebuild  ".rules.ML"  by calling make-rulenames!!! 
*)

signature ZF_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor ZF_RuleFun (ZF_Syntax: ZF_SYNTAX) : ZF_RULE = 
struct

val thy = extend_theory cla_thy "ZF"
   ([],
    [],
    [],
    [ (["i"], 	 		([],"term")),
      (["ulist","tuple"], 	([],"any")) ],
    ZF_Syntax.const_decs,   
    Some ZF_Syntax.sext)
[
 (* Bounded Quantifiers *)
    ("Ball_def", 	"Ball(A,P) == ALL x. x:A --> P(x)" ),
    ("Bex_def",		"Bex(A,P) == EX x. x:A & P(x)" ),
    ("subset_def",	"A <= B == ALL x:A. x:B" ),
    ("empty_set",	"~(x:0)" ),

 (* ZF axioms -- see Suppes p.238
    NB. Axioms for Union,Pow and Replace state existence only,
	uniqueness is derivable using extensionality.  *)

    ("extension",	"A = B <-> A <= B & B <= A" ),
    ("union_iff",	"A:Union(C) <-> (EX B:C. A:B)" ),
    ("power_set",	"A : Pow(B) <-> A <= B" ),
    ("succ_def",	"succ(i) == cons(i,i)" ),

 (*We may name this set, though it is not uniquely defined. *)
    ("infinity",	"0:Inf & (ALL y:Inf. succ(y): Inf)" ),

 (*This formulation facilitates case analysis on A. *)
    ("foundation",	"A=0 | (EX x:A. ALL y:x. ~ y:A)" ),

 (* Schema axiom since predicate P is a higher-order variable *)
    ("replacement",	"(!!x y z.[| x:A; P(x,y); P(x,z) |] ==> y=z) ==> \
\                        y : PrimReplace(A,P) <-> (EX x:A. P(x,y))" ),

 (* Derived form of replacement, restricting P to its functional part.
    The resulting set (for functional P) is the same as with
    PrimReplace, but the rules are simpler. *)
     ("Replace_def",	
      "Replace(A,P) == PrimReplace(A, %x y. (EX!z.P(x,z)) & P(x,y))" ),

 (* Functional form of replacement -- analgous to ML's map functional *)
     ("RepFun_def",	"RepFun(A,f) == Replace(A, %x u. u=f(x))" ),

 (* Separation and Pairing can be derived from the Replacement
    and Powerset Axioms using the following definitions.  *)

    ("Collect_def",	"Collect(A,P) == { y . x:A, x=y & P(x)}" ),

 (*Unordered pairs (Upair) are used to define binary union/intersection
   and cons; parsing routines translate the following set enumerations:
		      {a}      = cons(a,0)
		      {a,b,..} = cons(a,cons(b,...))  *)
    ("Upair_def",	
       "Upair(a,b) == {y. x:Pow(Pow(0)), (x=0 & y=a) | (x=Pow(0) & y=b)}" ),
    ("cons_def",	"cons(a,A) == Upair(a,a) Un A" ),

 (* Subsets, difference, small union and big and small intersections *)

    ("Diff_def",	"A - B    == { x:A . ~(x:B) }" ),
    ("Inter_def",	"Inter(A) == { x:Union(A) . ALL y:A. x:y}" ),
    ("Un_def",		"A Un  B  == Union(Upair(A,B))" ),
    ("Int_def",		"A Int B  == Inter(Upair(A,B))" ),

 (* Unique descriptions -- via Replace over the set "1" *)

    ("the_def",      "The(P) == Union({y . x:{0}, P(y)})" ),

 (* Ordered pairs and disjoint union of a family of sets *)

    (* this "symmetric" definition is more tractible than {{a}, {a,b}} *)
    ("Pair_def",	"<a,b>  == {{a,a}, {a,b}}" ),
    ("split_def",      "split(p,c) == THE y. EX a b. p=<a,b> & y=c(a,b)" ),
    ("fst_def",		"fst(p) == split(p, %x y.x)" ),
    ("snd_def",		"snd(p) == split(p, %x y.y)" ),

    ("converse_def",	(*the converse of relation r (inverse of function)*)
	"converse(r) == {yx. xy:r, EX x y. xy=<x,y> & yx=<y,x>}"),

    ("domain_def",     "domain(r) == {a. p:r, EX b. p=<a,b>}" ),
    ("range_def",      "range(r) == domain(converse(r))" ),
    ("field_def",      "field(r) == domain(r) Un range(r)" ),

    ("Sigma_def", "Sigma(A,B) == UN x:A. UN y:B(x). {<x,y>}" ),

 (* Abstraction, application and Cartesian product of a family of sets *)

    ("lam_def",		"Lambda(A,f) == RepFun(A, %x. <x,f(x)>)" ),
    ("apply_def",	"f`a == THE y. <a,y> : f" ),

    ("Pi_def", "Pi(A,B)  == {f: Pow(Sigma(A,B)). ALL x:A. EX! y. <x,y>: f}" ),

  (* Restrict the function f to the domain A *)
    ("restrict_def",    "restrict(f,A) == lam x:A.f`x"),

    ("image_def",       "r``A == {y : range(r) . EX x:A. <x,y> : r}"),
    ("vimage_def",      "r -`` A == converse(r)``A")

  ];


val sign = sign_of thy;
val ax = get_axiom thy;
(*INSERT-RULENAMES -- file produced by make-rulenames*)
end;

