(*  Title: 	ZF/func
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Functions in Zermelo-Fraenkel Set Theory
*)

(*** The Pi operator -- dependent function space ***)

val prems = goalw ZF_Rule.thy [Pi_def]
    "[| f <= Sigma(A,B);  !!x. x:A ==> EX! y. <x,y>: f |] ==> \
\     f: Pi(A,B)";  
by (REPEAT (ares_tac (prems @ [CollectI,PowI,ballI,impI]) 1));
val PiI = result();

(**Two "destruct" rules for Pi*)
val major::prems = goalw ZF_Rule.thy [Pi_def]
    "f: Pi(A,B) ==> f <= Sigma(A,B)";  
by (rtac (major RS CollectE) 1);
by (etac PowD 1);
val fun_is_rel = result();

val major::prems = goalw ZF_Rule.thy [Pi_def]
    "[| f: Pi(A,B);  a:A |] ==> EX! y. <a,y>: f";  
by (rtac (major RS CollectE) 1);
by (etac bspec 1);
by (resolve_tac prems 1);
val fun_unique_Pair = result();

val prems = goal ZF_Rule.thy
    "[| f: Pi(A,B); \
\       [| f <= Sigma(A,B);  ALL x:A. EX! y. <x,y>: f |] ==> P \
\    |] ==> P";  
by (REPEAT (ares_tac (prems@[ballI,fun_is_rel,fun_unique_Pair]) 1));
val PiE = result();

val prems = goalw ZF_Rule.thy [Pi_def]
    "[| A=A';  !!x. x:A' ==> B(x)=B'(x) |] ==> Pi(A,B) = Pi(A',B')";
by (prove_cong_tac (prems@[Collect_cong,Sigma_cong,ball_cong]) 1);
val Pi_cong = result();

(*** Function Application ***)

val prems = goalw ZF_Rule.thy [apply_def]
    "[| <a,b>: f;  f: Pi(A,B) |] ==> f`a = b";
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [asm_rl,PiE,SigmaE2] 1
     ORELSE ball_tac 1 ORELSE set_mp_tac 1
     ORELSE rtac the_equality 1));
by (etac ex1E 1);
(*both <a,y>:f and <a,ya>:f therefore y=b*)
by (rtac trans 1);
by (rtac sym 2);
by (REPEAT (eresolve_tac [asm_rl,mp,allE] 1));
val apply_equality = result();

val prems = goal ZF_Rule.thy
    "[| f: Pi(A,B);  \
\       c: f;        \
\       !!x. [| x:A;  c = <x,f`x> |] ==> P \
\    |] ==> P";
by (cut_facts_tac prems 1);
by (etac (fun_is_rel RS subsetD RS SigmaE) 1);
by (REPEAT (ares_tac prems 1));
by (hyp_subst_tac 1);
by (etac (apply_equality RS ssubst) 1);
by (resolve_tac prems 1);
by (rtac refl 1);
val memberPiE = result();

val prems = goal ZF_Rule.thy
    "[| <a,b>: f;  <a,c>: f;  f: Pi(A,B) |] ==> b=c";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [refl] 1  
     ORELSE eresolve_tac [apply_equality RS subst] 1));
val apply_equality2 = result();

(*Conclusion is flexible -- use res_inst_tac or else RS with a theorem
  of the form f:A->B *)
val prems = goal ZF_Rule.thy "[| f: Pi(A,B);  a:A |] ==> f`a : B(a)"; 
by (cut_facts_tac prems 1);
by (REPEAT (ball_tac 1 ORELSE set_mp_tac 1
     ORELSE eresolve_tac [PiE,SigmaE2,ex1E] 1));
by (eresolve_tac [apply_equality RS ssubst] 1);
by (REPEAT (ares_tac prems 1));
val apply_type = result();

val prems = goal ZF_Rule.thy "[| f: Pi(A,B);  a:A |] ==> <a,f`a>: f";
by (cut_facts_tac prems 1);
by (REPEAT (ball_tac 1 ORELSE eresolve_tac [PiE,ex1E] 1));
by (resolve_tac [apply_equality RS ssubst] 1);
by (REPEAT (ares_tac prems 1));
val apply_Pair = result();

val prems = goal ZF_Rule.thy
    "[| f: Pi(A,B);  a:A |] ==> <a,b>: f <-> f`a = b";
by (cut_facts_tac prems 1);
by (fast_tac (ZF_cs addIs [apply_Pair,apply_equality]) 1);
val apply_iff = result();

(*Refining one Pi type to another*)
val prems = goal ZF_Rule.thy
    "[| f: Pi(A,C);  !!x. x:A ==> f`x : B(x) |] ==> f : Pi(A,B)";
by (REPEAT (ares_tac (prems@[PiI,subsetI,SigmaI,fun_unique_Pair]) 1  
     ORELSE eresolve_tac ((prems RL [memberPiE]) @ [ssubst]) 1));
val Pi_type = result();


(** Elimination of membership in a function **)

val prems = goal ZF_Rule.thy "[| <a,b> : f;  f: Pi(A,B) |] ==> a : A";
by (resolve_tac (prems RL (prems RL [fun_is_rel RS subsetD RS SigmaD1])) 1);
val domain_type = result();

val prems = goal ZF_Rule.thy "[| <a,b> : f;  f: Pi(A,B) |] ==> b : B(a)";
by (resolve_tac (prems RL (prems RL [fun_is_rel RS subsetD RS SigmaD2])) 1);
val range_type = result();

val prems = goal ZF_Rule.thy
    "[| <a,b>: f;  f: Pi(A,B);       \
\       [| a:A;  b:B(a);  f`a = b |] ==> P  \
\    |] ==> P";
by (cut_facts_tac prems 1);
by (resolve_tac prems 1);
by (REPEAT (eresolve_tac [asm_rl,domain_type,range_type,apply_equality] 1));
val Pair_mem_PiE = result();

(*** Lambda Abstraction ***)

val prems = goalw ZF_Rule.thy [lam_def] "a:A ==> <a,b(a)> : (lam x:A. b(x))";  
by (REPEAT (ares_tac (prems @ [RepFunI,refl]) 1));
val lamI = result();

val major::prems = goalw ZF_Rule.thy [lam_def]
    "[| p: (lam x:A. b(x));  !!x.[| x:A; p=<x,b(x)> |] ==> P  \
\    |] ==>  P";  
by (rtac (major RS RepFunE) 1);
by (REPEAT (ares_tac prems 1));
val lamE = result();

val prems = goal ZF_Rule.thy "[| <a,c>: (lam x:A. b(x)) |] ==> c = b(a)";  
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [asm_rl,lamE,Pair_inject,ssubst] 1));
val lamD = result();

val prems = goal ZF_Rule.thy
    "[| !!x. x:A ==> b(x): B(x) |] ==> (lam x:A.b(x)) : Pi(A,B)";  
by (REPEAT (ares_tac (prems @ [PiI,ex1I,lamI,SigmaI,subsetI]) 1
     ORELSE eresolve_tac [lamE,Pair_inject,ssubst] 1));
val lam_type = result();

goal ZF_Rule.thy "(lam x:A.b(x)) :  A -> RepFun(A,b)";
by (REPEAT (ares_tac [refl,lam_type,RepFunI] 1));
val lam_funtype = result();

val prems = goal ZF_Rule.thy "a : A ==> (lam x:A.b(x)) ` a = b(a)";
by (REPEAT (resolve_tac (prems@[apply_equality,lam_funtype,lamI]) 1));
val beta_conv = result();

(*congruence rule for lambda abstraction*)
val prems = goalw ZF_Rule.thy [lam_def] 
    "[| A=A';  !!x. x:A' ==> b(x)=b'(x) |] ==>  \
\    (lam x:A.b(x)) = (lam x:A'.b'(x))";
by (rtac RepFun_cong 1);
by (res_inst_tac [("t","Pair")] subst_context2 2);
by (REPEAT (ares_tac (prems@[refl]) 1));
val lam_cong = result();

val [major] = goal ZF_Rule.thy
    "(!!x. x:A ==> EX! y. Q(x,y)) ==> EX h. ALL x:A. Q(x, h`x)";
by (res_inst_tac [("x", "lam x: A. THE y. Q(x,y)")] exI 1);
by (rtac ballI 1);
by (rtac (beta_conv RS ssubst) 1);
by (assume_tac 1);
by (etac (major RS theI) 1);
val lam_theI = result();


(** Extensionality **)

(*Semi-extensionality!*)
val prems = goal ZF_Rule.thy
    "[| f : Pi(A,B);  g: Pi(C,D);  A<=C; \
\       !!x. x:A ==> f`x = g`x       |] ==> f<=g";
by (rtac subsetI 1);
by (eresolve_tac (prems RL [memberPiE]) 1);
by (etac ssubst 1);
by (resolve_tac (prems RL [ssubst]) 1);
by (REPEAT (ares_tac (prems@[apply_Pair,subsetD]) 1));
val fun_subset = result();

val prems = goal ZF_Rule.thy
    "[| f : Pi(A,B);  g: Pi(A,D);  \
\       !!x. x:A ==> f`x = g`x       |] ==> f=g";
by (REPEAT (ares_tac (prems @ (prems RL [sym]) @
		      [subset_refl,equalityI,fun_subset]) 1));
val fun_extension = result();

val prems = goal ZF_Rule.thy
    "f : Pi(A,B) ==> (lam x:A. f`x) = f";
by (rtac fun_extension 1);
by (REPEAT (ares_tac (prems@[lam_type,apply_type,beta_conv]) 1));
val eta_conv = result();

(*Every element of Pi(A,B) may be expressed as a lambda abstraction!*)
val prems = goal ZF_Rule.thy
    "[| f: Pi(A,B);        \
\       !!b. [| ALL x:A. b(x):B(x);  f = (lam x:A.b(x)) |] ==> P   \
\    |] ==> P";
by (resolve_tac prems 1);
by (rtac (eta_conv RS sym) 2);
by (REPEAT (ares_tac (prems@[ballI,apply_type]) 1));
val Pi_lamE = result();


(*** properties of "restrict" ***)

val prems = goalw ZF_Rule.thy [restrict_def,lam_def]
    "[| f: Pi(C,B);  A<=C |] ==> restrict(f,A) <= f";
by (cut_facts_tac prems 1);
by (fast_tac (ZF_cs addIs [apply_Pair]) 1);
val restrict_subset = result();

val prems = goalw ZF_Rule.thy [restrict_def]
    "[| !!x. x:A ==> f`x: B(x) |] ==> restrict(f,A) : Pi(A,B)";  
by (rtac lam_type 1);
by (eresolve_tac prems 1);
val restrict_type = result();

val [pi,subs] = goal ZF_Rule.thy 
    "[| f: Pi(C,B);  A<=C |] ==> restrict(f,A) : Pi(A,B)";  
by (rtac (pi RS apply_type RS restrict_type) 1);
by (etac (subs RS subsetD) 1);
val restrict_type2 = result();

val prems = goalw ZF_Rule.thy [restrict_def]
    "a : A ==> restrict(f,A) ` a = f`a";
by (rtac beta_conv 1);
by (resolve_tac prems 1);
val restrict_conv = result();

(*NOT SAFE as a congruence rule for the simplifier!  Can cause it to fail!*)
val prems = goalw ZF_Rule.thy [restrict_def]
    "[| A=B;  !!x. x:B ==> f`x=g`x |] ==> restrict(f,A) = restrict(g,B)";
by (REPEAT (ares_tac (prems@[lam_cong]) 1));
val restrict_eqI = result();

goalw ZF_Rule.thy [restrict_def] "domain(restrict(f,C)) = C";
by (REPEAT (ares_tac [equalityI,subsetI,domainI,lamI] 1
     ORELSE eresolve_tac [domainE,lamE,Pair_inject,ssubst] 1));
val domain_restrict = result();

val [prem] = goalw ZF_Rule.thy [restrict_def]
    "A<=C ==> restrict(lam x:C. b(x), A) = (lam x:A. b(x))";
by (rtac (refl RS lam_cong) 1);
be (prem RS subsetD RS beta_conv) 1;	(*easier than calling SIMP_TAC*)
val restrict_lam_eq = result();



(*** Unions of functions ***)

(** The Union of a set of COMPATIBLE functions is a function **)
val [ex_prem,disj_prem] = goal ZF_Rule.thy
    "[| !!x. x:S ==> EX C D. x:C->D; \
\       !!x y. [| x:S;  y:S |] ==> x<=y | y<=x  |] ==>  \
\    Union(S) : domain(Union(S)) -> range(Union(S))";
val premE = ex_prem RS exE;
by (REPEAT (eresolve_tac [exE,PiE,premE] 1 
     ORELSE ares_tac [PiI,rel_Union,exI] 1));
by (REPEAT (eresolve_tac [asm_rl,domainE,UnionE,exE] 1 
     ORELSE ares_tac [allI,impI,ex1I,UnionI] 1));
by (res_inst_tac [ ("x1","B") ] premE 1);
by (res_inst_tac [ ("x1","Ba") ] premE 2);
by (REPEAT (eresolve_tac [asm_rl,exE] 1));
by (eresolve_tac [disj_prem RS disjE] 1);
by (DEPTH_SOLVE (set_mp_tac 1
		 ORELSE eresolve_tac [asm_rl, apply_equality2] 1));
val fun_Union = result();


(** The Union of 2 disjoint functions is a function **)

val prems = goal ZF_Rule.thy
    "[| f: A->B;  g: C->D;  A Int C = 0  |] ==>  \
\    (f Un g) : (A Un C) -> (B Un D)";
     (*Contradiction if A Int C = 0, a:A, a:B*)
val [disjoint] = prems RL ([IntI] RLN (2, [equals0D]));
by (cut_facts_tac prems 1);
by (rtac PiI 1);
(*solve subgoal 2 first!!*)
by (DEPTH_SOLVE_1 (eresolve_tac [UnE, Pair_mem_PiE, sym, disjoint] 2
       INTLEAVE ares_tac [ex1I, apply_Pair RS UnI1, apply_Pair RS UnI2] 2));
by (REPEAT (eresolve_tac [asm_rl,UnE,rel_Un,PiE] 1));
val fun_disjoint_Un = result();

val prems = goal ZF_Rule.thy
    "[| a:A;  f: A->B;  g: C->D;  A Int C = 0 |] ==>  \
\    (f Un g)`a = f`a";
by (REPEAT (ares_tac (prems@[apply_equality,UnI1,apply_Pair,
			     fun_disjoint_Un]) 1));
val fun_disjoint_apply1 = result();

val prems = goal ZF_Rule.thy
    "[| c:C;  f: A->B;  g: C->D;  A Int C = 0 |] ==>  \
\    (f Un g)`c = g`c";
by (REPEAT (ares_tac (prems@[apply_equality,UnI2,apply_Pair,
			     fun_disjoint_Un]) 1));
val fun_disjoint_apply2 = result();

(** Domain and range of a function/relation **)

val [major] = goal ZF_Rule.thy "f : Pi(A,B) ==> domain(f)=A";
by (rtac equalityI 1);
by (fast_tac (ZF_cs addIs [major RS apply_Pair]) 2);
by (rtac (major RS PiE) 1);
by (fast_tac ZF_cs 1);
val domain_of_fun = result();

val [major] = goal ZF_Rule.thy "f : Pi(A,B) ==> f : A->range(f)";
by (rtac (major RS Pi_type) 1);
by (etac (major RS apply_Pair RS rangeI) 1);
val range_of_fun = result();

(*** Extensions of functions ***)

(*Singleton function -- in the underlying form of singletons*)
goal ZF_Rule.thy "Upair(<a,b>,<a,b>) : Upair(a,a) -> Upair(b,b)";
by (fast_tac (ZF_cs addIs [PiI]) 1);
val fun_single_lemma = result();

val prems = goalw ZF_Rule.thy [cons_def]
    "[| f: A->B;  ~ c:A |]  ==> cons(<c,b>,f) : cons(c,A) -> cons(b,B)";
br (fun_single_lemma RS fun_disjoint_Un) 1;
brs prems 1;
br equals0I 1;
by (cfast_tac prems 1);
val fun_extend = result();

val prems = goal ZF_Rule.thy
    "[| f: A->B;  a:A;  ~ c:A |] ==> cons(<c,b>,f)`a = f`a";
br (apply_Pair RS consI2 RS apply_equality) 1;
br fun_extend 3;
by (REPEAT (resolve_tac prems 1));
val fun_extend_apply1 = result();

val prems = goal ZF_Rule.thy
    "[| f: A->B;  ~ c:A |] ==> cons(<c,b>,f)`c = b";
br (consI1 RS apply_equality) 1;
br fun_extend 1;
by (REPEAT (resolve_tac prems 1));
val fun_extend_apply2 = result();

(*The empty function*)
goal ZF_Rule.thy "0: 0->A";
by (fast_tac (ZF_cs addIs [PiI]) 1);
val fun_empty = result();

(*The singleton function*)
goal ZF_Rule.thy "{<a,b>} : {a} -> cons(b,C)";
by (REPEAT (ares_tac [fun_extend,fun_empty,notI] 1 ORELSE etac emptyE 1));
val fun_single = result();

