(*  Title: 	Pure/SYNTAX/ROOT
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

This file builds the parser generator.  It assumes the standard Isabelle
environment.
*)


use"xgram.ML";
use"extension.ML";
use"lexicon.ML";
use"parse_tree.ML";
use"earley0A.ML";
use"type_ext.ML";
use"sextension.ML";
use"pretty.ML";
use"printer.ML";
use"syntax.ML";

structure XGram = XGramFun(Symtab);
structure Extension = ExtensionFun(XGram);
structure Lexicon = LexiconFun(Extension);
structure ParseTree = ParseTreeFun(Lexicon);
structure Earley = EarleyFun(structure XGram=XGram and ParseTree=ParseTree);
structure TypeExt = TypeExtFun(structure Extension=Extension
				and Lexicon=Lexicon);
structure SExtension = SExtensionFun(TypeExt);
structure Pretty = PrettyFun();
structure Printer = PrinterFun(structure Lexicon=Lexicon and Pretty=Pretty
		and TypeExt=TypeExt and SExtension=SExtension and XGram=XGram);
structure Syntax = SyntaxFun(structure TypeExt=TypeExt and Parser=Earley and
			     SExtension=SExtension and Printer=Printer);

(*Basic_Syntax has the most important primitives, which are made pervasive*)
signature BASIC_SYNTAX = sig include SEXTENSION0 include PRINTER0 end;
structure Basic_Syntax : BASIC_SYNTAX = Syntax; 
