(*  Title: 	91/Modal/ruleshell
    Author: 	Martin Coen
    Copyright   1991  University of Cambridge
*)

signature RAW_MODAL_RULE =
sig
  structure LK_Rule : LK_RULE
  structure LK_Syntax : LK_SYNTAX
  val const_decs  : (string list * string) list
  val sext        : sext
  val sign        : Sign.sg
  val thy         : theory
  val rewrite_rls : thm list
  val safe_rls    : thm list
  val unsafe_rls  : thm list
  val bound_rls   : thm list
end;

functor RAW_MODAL_RuleFun (structure LK_Rule : LK_RULE 
			   and LK_Syntax     : LK_SYNTAX) : RAW_MODAL_RULE = 
struct
structure LK_Rule = LK_Rule;
structure LK_Syntax = LK_Syntax;

  val Lstar  =  "Lstar";
  val Rstar  =  "Rstar";
  val SLstar = "@Lstar";
  val SRstar = "@Rstar";

  val seq_tr1  = LK_Syntax.seq_tr1;
  val seq_tr1' = LK_Syntax.seq_tr1';

  fun star_tr c [s1,s2] = Const(c,dummyT)$seq_tr1 s1$seq_tr1 s2;
  fun star_tr' c [Abs(_,_,s1),Abs(_,_,s2)] = 
         Const(c,dummyT) $ seq_tr1' s1 $ seq_tr1' s2;

  val mixfix = 
    [ Mixfix("[]_",       "o=>o", "box", [50], 50),
      Mixfix("<>_",       "o=>o", "dia", [50], 50),
      Infixr("--<",       "[o,o]=>o", 25),     (* strict implication *)
      Infixr(">-<",       "[o,o]=>o", 25),     (* strict equivalence *)
      Mixfix("(_)|L>(_)", "[sequence,sequence]=>prop", SLstar, [6,6], 5),
      Mixfix("(_)|R>(_)", "[sequence,sequence]=>prop", SRstar, [6,6], 5)
    ];

  val const_decs = [([Lstar,Rstar], "[sobj=>sobj,sobj=>sobj]=>prop")];

  val sext = Sext{mixfix=mixfix,
                  parse_translation = [(SLstar,star_tr Lstar),
                                       (SRstar,star_tr Rstar)],
                  print_translation = [(Lstar,star_tr' SLstar),
                                       (Rstar,star_tr' SRstar)]};

val thy = extend_theory LK_Rule.thy "Modal"
( [],
  [],
  [], 
  [],
  const_decs,
  Some sext)
[
  (* Definitions *)

  ("strimp_def",          "P --< Q == [](P --> Q)"),
  ("streqv_def",          "P >-< Q == (P --< Q) & (Q --< P)")
];

val sign = sign_of thy;

val rewrite_rls = map (get_axiom thy) ["strimp_def","streqv_def"];

local open LK_Rule
in 
  val iffR = prove_goal thy 
      "[| $H,P |- $E,Q,$F;  $H,Q |- $E,P,$F |] ==> $H |- $E, P <-> Q, $F"
   (fn prems=>
    [ (rewrite_goals_tac [iff_def]),
      (REPEAT (resolve_tac (prems@[conjR,impR]) 1)) ]);

  val iffL = prove_goal thy 
     "[| $H,$G |- $E,P,Q;  $H,Q,P,$G |- $E |] ==> $H, P <-> Q, $G |- $E"
   (fn prems=>
    [ rewrite_goals_tac [iff_def],
      (REPEAT (resolve_tac (prems@[conjL,impL,basic]) 1)) ]);

  val safe_rls   = [basic,conjL,conjR,disjL,disjR,impL,impR,notL,notR,iffL,iffR];
  val unsafe_rls = [allR,exL];
  val bound_rls  = [allL,exR];
end;

end;
