(*  Title: 	91/Modal/S43
    Author: 	Martin Coen
    Copyright   1991  University of Cambridge

This implements Rajeev Gore's sequent calculus for S43.
*)

functor S43_RuleFun (structure Raw_Modal_Rule : RAW_MODAL_RULE) : MODAL_RULE = 
struct
structure Raw_Modal_Rule = Raw_Modal_Rule;

  val S43pi  =  "S43pi";
  val SS43pi = " S43pi";

  val tr  = Raw_Modal_Rule.LK_Syntax.seq_tr1;
  val tr' = Raw_Modal_Rule.LK_Syntax.seq_tr1';

  fun s43pi_tr[s1,s2,s3,s4,s5,s6]=Const(S43pi,dummyT)$tr s1$tr s2$tr s3$tr s4$tr s5$tr s6;
  fun s43pi_tr'[Abs(_,_,s1),Abs(_,_,s2),Abs(_,_,s3),Abs(_,_,s4),Abs(_,_,s5),Abs(_,_,s6)] =
                         Const(SS43pi,dummyT)$tr' s1$tr' s2$tr' s3$tr' s4$tr' s5$tr' s6;

  val mixfix = [Mixfix("S43pi((_);(_);(_);(_);(_);(_))", 
        "[sequence,sequence,sequence,sequence,sequence,sequence]=>prop",SS43pi,[],5)];

  val sext = Sext
	{ mixfix		= mixfix,
          parse_translation	= [(SS43pi,s43pi_tr)],
          print_translation	= [(S43pi,s43pi_tr')]
        };

  val const_decs = 
   [([S43pi],"[sobj=>sobj,sobj=>sobj,sobj=>sobj,sobj=>sobj,sobj=>sobj,sobj=>sobj]=>prop")];

val thy = extend_theory Raw_Modal_Rule.thy "S43" 
( [], 
  [], 
  [], 
  [], 
  const_decs, 
  Some sext)
[
(* Definition of the star operation using a set of Horn clauses  *)
(* For system S43: gamma * == {[]P | []P : gamma}                *)
(*                 delta * == {<>P | <>P : delta}                *)

  ("lstar0",         "|L>"),
  ("lstar1",         "$G |L> $H ==> []P, $G |L> []P, $H"),
  ("lstar2",         "$G |L> $H ==>   P, $G |L>      $H"),
  ("rstar0",         "|R>"),
  ("rstar1",         "$G |R> $H ==> <>P, $G |R> <>P, $H"),
  ("rstar2",         "$G |R> $H ==>   P, $G |R>      $H"),

(* Set of Horn clauses to generate the antecedents for the S43 pi rule       *)
(* ie                                                                        *)
(*           S1...Sk,Sk+1...Sk+m                                             *)
(*     ----------------------------------                                    *)
(*     <>P1...<>Pk, $G |- $H, []Q1...[]Qm                                    *)
(*                                                                           *)
(*  where Si == <>P1...<>Pi-1,<>Pi+1,..<>Pk,Pi, $G * |- $H *, []Q1...[]Qm    *)
(*    and Sj == <>P1...<>Pk, $G * |- $H *, []Q1...[]Qj-1,[]Qj+1...[]Qm,Qj    *)
(*    and 1<=i<=k and k<j<=k+m                                               *)

  ("S43pi0",         "S43pi $L;; $R;; $Lbox; $Rdia"),
  ("S43pi1",
   "[| (S43pi <>P,$L';     $L;; $R; $Lbox;$Rdia);   $L',P,$L,$Lbox |- $R,$Rdia |] ==> \
\       S43pi     $L'; <>P,$L;; $R; $Lbox;$Rdia"),
  ("S43pi2",
   "[| (S43pi $L';; []P,$R';     $R; $Lbox;$Rdia);  $L',$Lbox |- $R',P,$R,$Rdia |] ==> \
\       S43pi $L';;     $R'; []P,$R; $Lbox;$Rdia"),

(* Rules for [] and <> for S43 *)

  ("boxL",           "$E, P, $F, []P |- $G ==> $E, []P, $F |- $G"),
  ("diaR",           "$E |- $F, P, $G, <>P ==> $E |- $F, <>P, $G"),
  ("pi1",
   "[| $L1,<>P,$L2 |L> $Lbox;  $L1,<>P,$L2 |R> $Ldia;  $R |L> $Rbox;  $R |R> $Rdia;  \
\      S43pi ; $Ldia;; $Rbox; $Lbox; $Rdia |] ==> \
\   $L1, <>P, $L2 |- $R"),
  ("pi2",
   "[| $L |L> $Lbox;  $L |R> $Ldia;  $R1,[]P,$R2 |L> $Rbox;  $R1,[]P,$R2 |R> $Rdia;  \
\      S43pi ; $Ldia;; $Rbox; $Lbox; $Rdia |] ==> \
\   $L |- $R1, []P, $R2")
];

val sign = sign_of thy;

local val ax = get_axiom thy
in val lstar0    = ax"lstar0";
   val lstar1    = ax"lstar1";
   val lstar2    = ax"lstar2";
   val rstar0    = ax"rstar0";
   val rstar1    = ax"rstar1";
   val rstar2    = ax"rstar2";
   val S43pi0    = ax"S43pi0";
   val S43pi1    = ax"S43pi1";
   val S43pi2    = ax"S43pi2";
   val boxL      = ax"boxL";
   val diaR      = ax"diaR";
   val pi1     = ax"pi1";
   val pi2     = ax"pi2";
end;

local open Raw_Modal_Rule
in structure MP_Rule : MODAL_PROVER_RULE =
   struct
    val rewrite_rls = rewrite_rls
    val safe_rls    = safe_rls
    val unsafe_rls  = unsafe_rls @ [pi1,pi2]
    val bound_rls   = bound_rls @ [boxL,diaR]
    val aside_rls   = [lstar0,lstar1,lstar2,rstar0,rstar1,rstar2,S43pi0,S43pi1,S43pi2]
   end;
end;
structure Prover = Modal_ProverFun(MP_Rule);  

end;
