(*  Title: 	HOL/prod
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Ordered Pairs and the Cartesian product type
*)

structure Prod =
struct

val sext = Sext{
      mixfix = [ Delimfix("(1<_,/_>)", "['a,'b] => ('a,'b)prod", "Pair"),
                 TInfixl("*", "prod", 20) ],
      parse_translation = [],
      print_translation = []};

val thy = extend_theory Set.thy "Prod"
 ([],[],[],
  [(["prod"],([["term"],["term"]],"term"))],
  [(["Pair_Rep"],	"['a,'b] => ['a,'b] => bool"),
   (["Prod"],		"('a => 'b => bool)set"),
   (["Rep_Prod"],	"'a * 'b => ('a => 'b => bool)"),
   (["Abs_Prod"],	"('a => 'b => bool) => 'a * 'b"),
   (["fst"],	 	"'a * 'b => 'a"),
   (["snd"],	 	"'a * 'b => 'b"),
   (["split"],	 	"['a * 'b, ['a,'b]=>'c] => 'c")],
  Some sext)
 [
  ("Pair_Rep_def",	"Pair_Rep == (%a b. %x y. x=a & y=b)"),
  ("Prod_def",		"Prod == {f. ? a b. f = Pair_Rep(a,b)}"),
    (*faking a type definition...*)
  ("Rep_Prod", 		"Rep_Prod(p): Prod"),
  ("Rep_Prod_inverse", 	"Abs_Prod(Rep_Prod(p)) = p"),
  ("Abs_Prod_inverse", 	"f: Prod ==> Rep_Prod(Abs_Prod(f)) = f"),
    (*defining the abstract constants*)
  ("Pair_def",		"Pair(a,b) == Abs_Prod(Pair_Rep(a,b))"),
  ("fst_def",		"fst(p) == @a. ? b. p = <a,b>"),
  ("snd_def",		"snd(p) == @b. ? a. p = <a,b>"),
  ("split_def",		"split(p,c) == c(fst(p),snd(p))")
 ];
end;

local val ax = get_axiom Prod.thy
in
val Pair_Rep_def = ax"Pair_Rep_def";
val Prod_def    = ax"Prod_def";
val Rep_Prod    = ax"Rep_Prod";
val Rep_Prod_inverse    = ax"Rep_Prod_inverse";
val Abs_Prod_inverse    = ax"Abs_Prod_inverse";
val Pair_def    = ax"Pair_def";
val fst_def     = ax"fst_def";
val snd_def     = ax"snd_def";
val split_def   = ax"split_def";
end;

(*This counts as a non-emptiness result for admitting 'a * 'b as a type*)
goalw Prod.thy [Prod_def] "Pair_Rep(a,b) : Prod";
by (EVERY1 [rtac CollectI, rtac exI, rtac exI, rtac refl]);
val ProdI = result();

val [major] = goalw Prod.thy [Pair_Rep_def]
    "Pair_Rep(a, b) = Pair_Rep(a',b') ==> a=a' & b=b'";
by (EVERY1 [rtac (major RS fun_cong RS fun_cong RS subst), 
	    rtac conjI, rtac refl, rtac refl]);
val Pair_Rep_inject = result();

goal Prod.thy "inj_onto(Abs_Prod,Prod)";
by (rtac inj_onto_inverseI 1);
by (etac Abs_Prod_inverse 1);
val inj_onto_Abs_Prod = result();

val prems = goalw Prod.thy [Pair_def]
    "[| <a, b> = <a',b'>;  [| a=a';  b=b' |] ==> R |] ==> R";
by (rtac (inj_onto_Abs_Prod RS inj_ontoD RS Pair_Rep_inject RS conjE) 1);
by (REPEAT (ares_tac (prems@[ProdI]) 1));
val Pair_inject = result();

goal Prod.thy "(<a,b>=<a',b'>) = (a=a' & b=b')";
by (fast_tac (set_cs addIs [Pair_inject]) 1);
val Prod_eq = result();

goalw Prod.thy [fst_def] "fst(<a,b>) = a";
by (fast_tac (set_cs addIs [select_equality] addEs [Pair_inject]) 1);
val fst_conv = result();

goalw Prod.thy [snd_def] "snd(<a,b>) = b";
by (fast_tac (set_cs addIs [select_equality] addEs [Pair_inject]) 1);
val snd_conv = result();

goalw Prod.thy [Pair_def] "? x y. p = <x,y>";
by (rtac (rewrite_rule [Prod_def] Rep_Prod RS CollectE) 1);
by (EVERY1[etac exE, etac exE, rtac exI, rtac exI,
	   rtac (Rep_Prod_inverse RS sym RS trans),  etac arg_cong]);
val PairE_lemma = result();

(*The general elimination rule -- could resemble sumE instead*)
val [prem] = goal Prod.thy "[| !!x y. p=<x,y> ==> Q |] ==> Q";
by (rtac (PairE_lemma RS exE) 1);
by (REPEAT (eresolve_tac [prem,exE] 1));
val PairE = result();

val Pair_ss = 
    HOL_ss addcongs (mk_congs Prod.thy ["Pair","fst","snd"])
           addrews [fst_conv, snd_conv];

goal Prod.thy "p = <fst(p),snd(p)>";
by (res_inst_tac [("p","p")] PairE 1);
by (ASM_SIMP_TAC Pair_ss 1);
val surjective_pairing = result();

goalw Prod.thy [split_def] "split(<a,b>, c) = c(a,b)";
by (sstac [fst_conv, snd_conv] 1);
by (rtac refl 1);
val split_conv = result();

val prems = goal Prod.thy "c(a,b) ==> split(<a,b>, c)";
by (stac split_conv 1);
by (resolve_tac prems 1);
val splitI = result();

val prems = goalw Prod.thy [split_def]
    "[| split(p,c);  !!x y. [| p=<x,y>;  c(x,y) |] ==> Q |] ==> Q";
by (REPEAT (resolve_tac (prems@[surjective_pairing]) 1));
val splitE = result();
