(*  Title: 	FOL/ex/prolog
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

First-Order Logic: PROLOG examples
*)

writeln"File FOL/ex/prolog.";

val sext =
    Sext{mixfix   = [ Infixr("#", "['a, 'a list]=> 'a list", 60) ],
         print_translation = [], 
         parse_translation = []};

val prolog_thy = extend_theory FOL_thy "prolog"
 ([],						(* new classes *)
  [], 						(* default sort *)
  [], 						(* old types *)
  [(["list"], ([["term"]],"term"))], 		(* new types *)
  [(["Nil"], "'a list"),			(* constants *)
   (["app"], "['a list, 'a list, 'a list] => o"),
   (["rev"], "['a list, 'a list] => o")], 
  Some sext)
 [("appNil",  "app(Nil,ys,ys)"),
  ("appCons", "app(xs,ys,zs) ==> app(x#xs, ys, x#zs)"),
  ("revNil",  "rev(Nil,Nil)"),
  ("revCons", "[| rev(xs,ys);  app(ys, x#Nil, zs) |] ==>  \
\              rev(x#xs, zs)")];

val appNil  = get_axiom prolog_thy "appNil";
val appCons = get_axiom prolog_thy "appCons";
val revNil  = get_axiom prolog_thy "revNil";
val revCons = get_axiom prolog_thy "revCons";

goal prolog_thy "app(a#b#c#Nil, d#e#Nil, ?x)";
by (resolve_tac [appNil,appCons] 1);
by (resolve_tac [appNil,appCons] 1);
by (resolve_tac [appNil,appCons] 1);
by (resolve_tac [appNil,appCons] 1);
prth (result());

goal prolog_thy "app(?x, c#d#Nil, a#b#c#d#Nil)";
by (REPEAT (resolve_tac [appNil,appCons] 1));
result();


goal prolog_thy "app(?x, ?y, a#b#c#d#Nil)";
by (REPEAT (resolve_tac [appNil,appCons] 1));
back();
back();
back();
back();
result();


goal prolog_thy "rev(a#b#c#d#Nil, ?x)";
val rules = [appNil,appCons,revNil,revCons];
by (REPEAT (resolve_tac rules 1));

goal prolog_thy "rev(?x, a#b#c#Nil)";
by (REPEAT (resolve_tac rules 1)); (*does not solve it directly!*)
back();
back();

val prolog_tac = DEPTH_FIRST (has_fewer_prems 1) (resolve_tac rules 1);

choplev 0;
by prolog_tac;
result();


goal prolog_thy "rev(a#?x#c#?y#Nil, d#?z#b#?u)";
by prolog_tac;


writeln"Reached end of file.";
