(*  Title: 	FOL/ex/intro
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Examples for Introduction to Isabelle

Defines FOL_thy, which extends classical FOL with type nat, constants 0 and Suc

Derives some inference rules; illustrates definitions and theory extensions

To generate similar output to manual, execute these commands:
    Pretty.setmargin 72; print_depth 0;
****)


(**** DEFINITION OF FOL_THY ****)

(*FOL_thy, as used in the manual, includes the constants Suc and 0, 
  which are not present in Int_Rule.thy. *)

(*syntax extension: 0 is a valid term*)
val sext = 
    Sext{mixfix		   = [Delimfix("0", "nat", "0")],
	 parse_translation = [],
	 print_translation = []};

val FOL_thy = extend_theory cla_thy "Intro_FOL"
 ([], 				(* new classes *)
  [], 				(* default sort *)
  [], 				(* old types *)
  [(["nat"], ([],"term"))], 	(* new types *)
  [(["Suc"], "nat => nat")], 	(* constants *)
  Some sext)
 [];  (*no axioms!*)




(**** SOME SIMPLE BACKWARD PROOFS ****)

goal FOL_thy "P|P --> P";
by (resolve_tac [impI] 1);
by (resolve_tac [disjE] 1);
by (assume_tac 3);
by (assume_tac 2);
by (assume_tac 1);
val mythm = prth(result());

goal FOL_thy "(P & Q) | R  --> (P | R)";
by (resolve_tac [impI] 1);
by (eresolve_tac [disjE] 1);
by (dresolve_tac [conjunct1] 1);
by (resolve_tac [disjI1] 1);
by (resolve_tac [disjI2] 2);
by (REPEAT (assume_tac 1));
prth (result());

(*Correct version, delaying use of "spec" until last*)
goal FOL_thy "(ALL x y.P(x,y))  -->  (ALL z w.P(w,z))";
by (resolve_tac [impI] 1);
by (resolve_tac [allI] 1);
by (resolve_tac [allI] 1);
by (dresolve_tac [spec] 1);
by (dresolve_tac [spec] 1);
by (assume_tac 1);
prth (result());


(**** DEMONSTRATION OF FAST_TAC ****)


goal FOL_thy "(EX y. ALL x. J(y,x) <-> ~J(x,x))  \
\       -->  ~ (ALL x. EX y. ALL z. J(z,y) <-> ~ J(z,x))";
by (fast_tac FOL_cs 1);


goal FOL_thy "ALL x. P(x,f(x)) <-> \
\       (EX y. (ALL z. P(z,y) --> P(z,f(x))) & P(x,y))";
by (fast_tac FOL_cs 1);


(**** DERIVATION OF CONJUNCTION ELIMINATION RULE ****)


val [major,minor] = goal FOL_thy
    "[| P&Q;  [| P; Q |] ==> R |] ==> R";
by (resolve_tac [minor] 1);
by (resolve_tac [major RS conjunct1] 1);
by (resolve_tac [major RS conjunct2] 1);
prth (topthm());
prth(result());


(**** DERIVED RULES INVOLVING DEFINITIONS ****)

(** DERIVATION OF NEGATION INTRODUCTION **)

val prems = goal FOL_thy "(P ==> False) ==> ~P";
by (rewrite_goals_tac [not_def]);
by (resolve_tac [impI] 1);
by (resolve_tac prems 1);
by (assume_tac 1);
prth(result());

val [major,minor] = goal FOL_thy "[| ~P;  P |] ==> R";
by (resolve_tac [FalseE] 1);
by (resolve_tac [mp] 1);
by (resolve_tac [rewrite_rule [not_def] major] 1);
by (resolve_tac [minor] 1);
prth(result());

(*Alternative proof of above result*)
val [major,minor] = goalw FOL_thy [not_def]
    "[| ~P;  P |] ==> R";
by (resolve_tac [minor RS (major RS mp RS FalseE)] 1);
prth(result());



(**** DEFINITION OF nat_thy, ADDING PEANO'S AXIOMS ****)

val nat_thy = extend_theory FOL_thy "Nat"
 ([], 						(* new classes *)
  [], 						(* default sort *)
  [], 						(* old types *)
  [], 						(* new types *)
  [(["rec"], "[nat, 'a, [nat,'a]=>'a] => 'a"),	(* constants *)
   (["add"], "[nat, nat] => nat")], 	
  None)
 [("induct", 	 "[| P(0);  !!x. P(x) ==> P(Suc(x)) |]  ==> P(n)"),
  ("Suc_inject", "Suc(m)=Suc(n) ==> m=n"),
  ("Suc_neq_0",  "Suc(m)=0      ==> R"),
  ("rec_0",      "rec(0,a,f) = a"),
  ("rec_Suc",    "rec(Suc(m), a, f) = f(m, rec(m,a,f))"),
  ("add_def",    "add(m,n) == rec(m, n, %x y. Suc(y))")];

val ax = get_axiom nat_thy;
val induct      = ax"induct";
val Suc_inject  = ax"Suc_inject";
val Suc_neq_0   = ax"Suc_neq_0";
val rec_0       = ax"rec_0";
val rec_Suc     = ax"rec_Suc";
val add_def     = ax"add_def";


goal nat_thy "~ (Suc(k) = k)";
by (res_inst_tac [("n","k")] induct 1);
by (resolve_tac [notI] 1);
by (eresolve_tac [Suc_neq_0] 1);
by (resolve_tac [notI] 1);
by (eresolve_tac [notE] 1);
by (eresolve_tac [Suc_inject] 1);
val Suc_n_not_n = prth (result());


goal nat_thy "add(add(k,m),n) = add(k,add(m,n))";
prths ([induct] RL [topthm()]);  (*prints all 14 next states!*)
by (resolve_tac [induct] 1);
back();
back();
back();
back();
back();
back();

goalw nat_thy [add_def] "add(0,n) = n";
by (resolve_tac [rec_0] 1);
val add_0 = prth (result());

goalw nat_thy [add_def] "add(Suc(m), n) = Suc(add(m,n))";
by (resolve_tac [rec_Suc] 1);
val add_Suc = prth (result());

val nat_congs = prths (mk_congs nat_thy ["Suc", "add"]);

val add_ss = FOL_ss  addcongs nat_congs  
	             addrews  [add_0, add_Suc];

goal nat_thy "add(add(k,m),n) = add(k,add(m,n))";
by (res_inst_tac [("n","k")] induct 1);
by (SIMP_TAC add_ss 1);
by (ASM_SIMP_TAC add_ss 1);
val add_assoc = prth (result());



writeln"Reached end of file.";
