(*  Title: 	ZF/subset
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Derived rules involving subsets
Union and Intersection as lattice operations
*)

(*** cons ***)

goal set_thy "B <= cons(a,B)";
by (REPEAT (ares_tac [subsetI,consI2] 1));
val cons_refl = result();

val prems = goal set_thy "[| a:C; B<=C |] ==> cons(a,B) <= C";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac  [consE,ssubst,subsetD] 1));
val cons_subsetI = result();

(*A special case of subset elimination, adding no new variables *)
val prems = goal set_thy
    "[| cons(a,B) <= C;  [| a:C;  B<=C |] ==> P \
\    |] ==> P";
by (cut_facts_tac prems 1);
by (resolve_tac prems 1);
by (REPEAT (ares_tac [subsetI,consI1,consI2] 1
     ORELSE etac subsetD 1));
val cons_subsetE = result();

(*** succ ***)

val prems = goalw set_thy [succ_def] "[| i:j;  i<=j |] ==> succ(i)<=j";
by (REPEAT (ares_tac (prems@[cons_subsetI]) 1));
val succ_subsetI = result();

val major::prems = goalw set_thy [succ_def] 
    "[| succ(i) <= j;  [| i:j;  i<=j |] ==> P \
\    |] ==> P";
br (major RS cons_subsetE) 1;
by (REPEAT (ares_tac prems 1));
val succ_subsetE = result();

(*** singletons ***)

val prems = goal set_thy
    "a:C ==> {a} <= C";
by (REPEAT (resolve_tac (prems@[cons_subsetI,empty_subsetI]) 1));
val singleton_subsetI = result();

val prems = goal set_thy
    "{a} <= C  ==>  a:C";
by (REPEAT (ares_tac (prems@[cons_subsetE]) 1));
val singleton_subsetD = result();

(*** Big Union -- least upper bound of a set  ***)

val prems = goal set_thy
    "B:A ==> B <= Union(A)";
by (REPEAT (ares_tac (prems@[subsetI,UnionI]) 1));
val Union_upper = result();

val prems = goal set_thy               (* B is new variable *)
    "[| B:A;  C<=B |] ==> C <= Union(A)";
by (rtac subset_trans 1);
by (REPEAT (resolve_tac (prems@[Union_upper]) 1));
val Union_upperbound = result();

val prems = goal set_thy
    "[| !!x. x:A ==> x<=C |] ==> Union(A) <= C";
by (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac ([UnionE]@(prems RL [subsetD])) 1));
val Union_least = result();

val prems = goal set_thy
    "[| !!x. x:A ==> f(x)<=C |] ==> Union(RepFun(A,f)) <= C";
by (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac ([UN_E]@(prems RL [subsetD])) 1));
val UN_least = result();


(*** Big Intersection -- greatest lower bound of a nonempty set ***)

val prems = goal set_thy "B:A ==> Inter(A) <= B";
by (REPEAT (resolve_tac (prems@[subsetI]) 1
     ORELSE etac InterD 1));
val Inter_lower = result();

val prems = goal set_thy               (* B is new variable *)
    "[| B:A;  B<=C |] ==> Inter(A) <= C";
by (rtac subset_trans 1);
by (REPEAT (resolve_tac (prems@[Inter_lower]) 1));
val Inter_lowerbound = result();

val prems = goal set_thy
    "[| a:A;  !!x. x:A ==> C<=x |] ==> C <= Inter(A)";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [subsetI,InterI] 1
     ORELSE eresolve_tac (prems RL [subsetD]) 1));
val Inter_greatest = result();

(*** Finite Union -- the least upper bound of 2 sets ***)

goal set_thy "A <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI1] 1));
val Un_upper1 = result();

goal set_thy "B <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI2] 1));
val Un_upper2 = result();

val prems = goal set_thy "C<=A ==> C <= A Un B";
by (rtac subset_trans 1);
by (resolve_tac prems 1);
by (rtac Un_upper1 1);
val Un_upperbound1 = result();

val prems = goal set_thy "C<=B ==> C <= A Un B";
by (rtac subset_trans 1);
by (resolve_tac prems 1);
by (rtac Un_upper2 1);
val Un_upperbound2 = result();

val prems = goal set_thy "[| A<=C;  B<=C |] ==> A Un B <= C";
by (cut_facts_tac prems 1);
by (DEPTH_SOLVE (ares_tac [subsetI] 1 
          ORELSE eresolve_tac [UnE,subsetD] 1));
val Un_least = result();

(*** Finite Intersection -- the greatest lower bound of 2 sets *)

goal set_thy "A Int B <= A";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower1 = result();

goal set_thy "A Int B <= B";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower2 = result();

val prems = goal set_thy "A<=C ==> A Int B <= C";
by (resolve_tac [Int_lower1 RS subset_trans] 1);
by (resolve_tac prems 1);
val Int_lowerbound1 = result();

val prems = goal set_thy "B<=C ==> A Int B <= C";
by (resolve_tac [Int_lower2 RS subset_trans] 1);
by (resolve_tac prems 1);
val Int_lowerbound2 = result();

val prems = goal set_thy "[| C<=A;  C<=B |] ==> C <= A Int B";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [subsetI,IntI] 1
     ORELSE etac subsetD 1));
val Int_greatest = result();

(*** Set difference *)

goal set_thy "A-B <= A";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac DiffE 1));
val Diff_subset = result();

val prems = goal set_thy "[| C<=A;  C Int B = 0 |] ==> C <= A-B";
by (cut_facts_tac prems 1);
br subsetI 1;
by (REPEAT (ares_tac [DiffI,IntI,notI] 1
     ORELSE eresolve_tac [subsetD,equals0D] 1));
val Diff_contains = result();

(** Collect **)

goal set_thy "Collect(A,P) <= A";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac CollectD1 1));
val Collect_subset = result();

