(*  Title: 	ZF/rules
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Rules for Zermelo-Fraenkel Set Theory 

CALLED RULES, NOT RULESHELL, SINCE IT DOES NOT INVOLVE MODULES
AND DOES NOT NEED MAKE-RULENAMES
 -- instead, call "get-rulenames" after modification
*)

val set_thy = extend_theory cla_thy "set" 
   ([], 
    [], 
    [ (["i"], 	 		([],"term")),
      (["ulist","tuple"], 	([],"any")) ],
    const_decs,   
    Some sext)
[
 (* Bounded Quantifiers *)
    ("Ball_def", 	"Ball(A,P) == ALL x. x:A --> P(x)" ),
    ("Bex_def",		"Bex(A,P) == EX x. x:A & P(x)" ),
    ("subset_def",	"A <= B == ALL x:A. x:B" ),
    ("empty_set",	"~(x:0)" ),

 (* ZF axioms -- see Suppes p.238
    NB. Axioms for Union,Pow and Replace state existence only,
	uniqueness is derivable using extensionality.  *)

    ("extension",	"A = B <-> A <= B & B <= A" ),
    ("union_iff",	"A:Union(C) <-> (EX B:C. A:B)" ),
    ("power_set",	"A : Pow(B) <-> A <= B" ),
    ("succ_def",	"succ(i) == cons(i,i)" ),

 (*We may name this set, though it is not uniquely defined. *)
    ("infinity",	"0:Inf & (ALL y:Inf. succ(y): Inf)" ),

 (*This formulation facilitates case analysis on A. *)
    ("foundation",	"A=0 | (EX x:A. ALL y:x. ~ y:A)" ),

 (* Schema axiom since predicate P is a higher-order variable *)
    ("replacement",	"(!!x y z.[| x:A; P(x,y); P(x,z) |] ==> y=z) ==> \
\                        y : PrimReplace(A,P) <-> (EX x:A. P(x,y))" ),

 (* Derived form of replacement, restricting P to its functional part.
    The resulting set (for functional P) is the same as with
    PrimReplace, but the rules are simpler. *)
     ("Replace_def",	
      "Replace(A,P) == PrimReplace(A, %x y. (EX!z.P(x,z)) & P(x,y))" ),

 (* Functional form of replacement -- analgous to ML's map functional *)
     ("RepFun_def",	"RepFun(A,f) == Replace(A, %x u. u=f(x))" ),

 (* Separation and Pairing can be derived from the Replacement
    and Powerset Axioms using the following definitions.  *)

    ("Collect_def",	"Collect(A,P) == { y . x:A, x=y & P(x)}" ),

 (*Unordered pairs (Upair) are used to define binary union/intersection
   and cons; parsing routines translate the following set enumerations:
		      {a}      = cons(a,0)
		      {a,b,..} = cons(a,cons(b,...))  *)
    ("Upair_def",	
       "Upair(a,b) == {y. x:Pow(Pow(0)), (x=0 & y=a) | (x=Pow(0) & y=b)}" ),
    ("cons_def",	"cons(a,A) == Upair(a,a) Un A" ),

 (* Subsets, difference, small union and big and small intersections *)

    ("strict_subset_def",	"A <! B   == A <=B & ~(A=B)" ),
    ("Diff_def",	"A - B    == { x:A . ~(x:B) }" ),
    ("Inter_def",	"Inter(A) == { x:Union(A) . ALL y:A. x:y}" ),
    ("Un_def",		"A Un  B  == Union(Upair(A,B))" ),
    ("Int_def",		"A Int B  == Inter(Upair(A,B))" ),

 (* Unique descriptions -- via Replace over the set "1" *)

    ("the_def",      "The(P) == Union({y . x:{0}, P(y)})" ),

 (* Ordered pairs and disjoint union of a family of sets *)

    (* this "symmetric" definition is more tractible than {{a}, {a,b}} *)
    ("Pair_def",	"<a,b>  == {{a,a}, {a,b}}" ),
    ("fst_def",		"fst(A) == THE x. EX y. A=<x,y>" ),
    ("snd_def",		"snd(A) == THE y. EX x. A=<x,y>" ),

    ("domain_def",     "domain(r) == {a:Union(Union(r)) . EX b. <a,b> : r}" ),
    ("range_def",      "range(r) == {b:Union(Union(r)) . EX a. <a,b> : r}" ),
    ("field_def",      "field(r) == domain(r) Un range(r)" ),

    ("split_def",      "split(p,c) == THE y. EX a b. p=<a,b> & y=c(a,b)" ),

    ("Sigma_def", "Sigma(A,B) == UN x:A. UN y:B(x). {<x,y>}" ),

 (* Abstraction, application and Cartesian product of a family of sets *)

    ("lam_def",		"Lambda(A,f) == RepFun(A, %x. <x,f(x)>)" ),
    ("apply_def",	"f`a == THE y. <a,y> : f" ),

    ("Pi_def", "Pi(A,B)  == {f: Pow(Sigma(A,B)). ALL x:A. EX! y. <x,y>: f}" ),

  (* Restrict the function f to the domain A *)
    ("restrict_def",    "restrict(f,A) == lam x:A.f`x"),

    ("image_def",       "r``A == {y : range(r) . EX x:A. <x,y> : r}"),
    ("vimage_def",      "r -`` A == {x : domain(r) . EX y:A. <x,y> : r}")

  ];

(*The signature of the theory*)

local val ax = get_axiom set_thy
in
val Ball_def = ax"Ball_def";
val Bex_def = ax"Bex_def";
val subset_def = ax"subset_def";
val empty_set = ax"empty_set";
val extension = ax"extension";
val union_iff = ax"union_iff";
val power_set = ax"power_set";
val succ_def = ax"succ_def";
val infinity = ax"infinity";
val foundation = ax"foundation";
val replacement = ax"replacement";
val Replace_def = ax"Replace_def";
val RepFun_def = ax"RepFun_def";
val Collect_def = ax"Collect_def";
val Upair_def = ax"Upair_def";
val strict_subset_def = ax"strict_subset_def";
val Diff_def = ax"Diff_def";
val Inter_def = ax"Inter_def";
val Un_def = ax"Un_def";
val Int_def = ax"Int_def";
val cons_def = ax"cons_def";
val the_def = ax"the_def";
val Pair_def = ax"Pair_def";
val fst_def = ax"fst_def";
val snd_def = ax"snd_def";
val domain_def = ax"domain_def";
val range_def = ax"range_def";
val field_def = ax"field_def";
val split_def = ax"split_def";
val Sigma_def = ax"Sigma_def";
val lam_def = ax"lam_def";
val apply_def = ax"apply_def";
val Pi_def = ax"Pi_def";
val restrict_def = ax"restrict_def";
val image_def = ax"image_def";
val vimage_def = ax"vimage_def";
end;
