(*  Title: 	ZF/bool
    Author: 	Martin D Coen, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Booleans in Zermelo-Fraenkel Set Theory 
*)

writeln"File ZF/ex/bool";

structure Bool =
struct
val const_decs = 
 [ 
   (["bool"],	"i"),
   (["cond"],	"[i,i,i]=>i")
 ];

val sext = Sext{mixfix = [ Delimfix("1", "i", "1") ],
		parse_translation= [],
		print_translation= []};

val thy = extend_theory Nat.thy "bool"
     ([], [], [], const_decs, Some sext)
 [
  ("one_def",	"1  == succ(0)"),
  ("bool_def",	"bool == {0,1}"),
  ("cond_def", "cond(b,t,u) == nat_case(b, u, %x.t)")
 ];
end;

local val ax = get_axiom Bool.thy
in val one_def 	= ax"one_def";
   val bool_def 	= ax"bool_def";
   val cond_def 	= ax"cond_def";
end;

val bool_defs = [bool_def,one_def,cond_def];


(* booleans *)

val prems = goalw Bool.thy bool_defs "0 : bool";
by (rtac consI1 1);
val boolI0 = result();

val prems = goalw Bool.thy bool_defs "1 : bool";
by (rtac (consI1 RS consI2) 1);
val boolI1 = result();

val [major] = goalw Bool.thy bool_defs "1 = 0 ==> P";
by (rtac (major RS succ_neq_0) 1);
val one_eq_0 = result();

val prems = goalw Bool.thy bool_defs "[| c: bool;  P(1);  P(0) |] ==> P(c)";
by (cut_facts_tac prems 1);
by (fast_tac ZF_cs 1);
val boolE = result();

(** cond **)

goalw Bool.thy bool_defs "cond(1,t,u) = t";
by (rtac nat_case_succ_conv 1);
val cond_1_conv = result();

goalw Bool.thy bool_defs "cond(0,t,u) = u";
by (rtac nat_case_0_conv 1);
val cond_0_conv = result();

val major::prems = goal Bool.thy 
    "[|  b: bool;  t: A(1);  u: A(0) |] ==> cond(b,t,u): A(b)";
by (rtac (major RS boolE) 1);
by (rtac (cond_1_conv RS ssubst) 1);
by (rtac (cond_0_conv RS ssubst) 2);
by (resolve_tac prems 1);
by (resolve_tac prems 1);
val cond_type = result();

