(*  Title: 	91/Modal/T
    Author: 	Martin Coen
    Copyright   1991  University of Cambridge
*)

functor T_RuleFun (structure Raw_Modal_Rule : RAW_MODAL_RULE) : MODAL_RULE = 
struct
structure Raw_Modal_Rule = Raw_Modal_Rule;

val const_decs = Raw_Modal_Rule.const_decs;
val sext = Raw_Modal_Rule.sext;

val thy = extend_theory Raw_Modal_Rule.thy "T"
( [], 
  [], 
  [], 
  [], 
  None)
[
(* Definition of the star operation using a set of Horn clauses *)
(* For system T:  gamma * == {P | []P : gamma}                  *)
(*                delta * == {P | <>P : delta}                  *)

  ("lstar0",         "|L>"),
  ("lstar1",         "$G |L> $H ==> []P, $G |L> P, $H"),
  ("lstar2",         "$G |L> $H ==>   P, $G |L>    $H"),
  ("rstar0",         "|R>"),
  ("rstar1",         "$G |R> $H ==> <>P, $G |R> P, $H"),
  ("rstar2",         "$G |R> $H ==>   P, $G |R>    $H"),

(* Rules for [] and <> *)

  ("boxR",
   "[| $E |L> $E';  $F |R> $F';  $G |R> $G';  \
\               $E'        |- $F', P, $G'|] ==> $E          |- $F, []P, $G"),
  ("boxL",     "$E, P, $F  |-         $G    ==> $E, []P, $F |-          $G"),
  ("diaR",     "$E         |- $F, P,  $G    ==> $E          |- $F, <>P, $G"),
  ("diaL",
   "[| $E |L> $E';  $F |L> $F';  $G |R> $G';  \
\               $E', P, $F'|-         $G'|] ==> $E, <>P, $F |-          $G")
];

val sign = sign_of thy;

local val ax = get_axiom thy
in val lstar0  = ax"lstar0";
   val lstar1  = ax"lstar1";
   val lstar2  = ax"lstar2";
   val rstar0  = ax"rstar0";
   val rstar1  = ax"rstar1";
   val rstar2  = ax"rstar2";
   val boxR    = ax"boxR";
   val boxL    = ax"boxL";
   val diaR    = ax"diaR";
   val diaL    = ax"diaL";
end;

local open Raw_Modal_Rule
in structure MP_Rule : MODAL_PROVER_RULE =
   struct
    val rewrite_rls = rewrite_rls
    val safe_rls    = safe_rls
    val unsafe_rls  = unsafe_rls @ [boxR,diaL]
    val bound_rls   = bound_rls @ [boxL,diaR]
    val aside_rls   = [lstar0,lstar1,lstar2,rstar0,rstar1,rstar2]
   end;
end;
structure Prover = Modal_ProverFun(MP_Rule);  

end;
