(*  Title: 	91/Modal/ROOT
    Author: 	Martin Coen
    Copyright   1991  University of Cambridge
*)

writeln"Root file for Modal Sequent Calculus";

use "ruleshell.ML";
use "prover.ML";

signature MODAL_RULE =
sig
  structure Raw_Modal_Rule : RAW_MODAL_RULE
  structure Prover : MODAL_PROVER
  val const_decs   : (string list * string) list
  val sext         : Sign.Syntax.sext
  val sign         : Sign.sg
  val thy          : theory
end;

use "T.ML";
use "S4.ML";
use "S43.ML";

structure Raw_Modal = RAW_MODAL_RuleFun
    (structure LK_Rule=LK_Rule and LK_Syntax=LK_Syntax);

structure T   = T_RuleFun(structure Raw_Modal_Rule=Raw_Modal);
structure S4  = S4_RuleFun(structure Raw_Modal_Rule=Raw_Modal);
structure S43 = S43_RuleFun(structure Raw_Modal_Rule=Raw_Modal);
