(*  Title: 	LK/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds Classical Sequent Calculus to a database containing pure Isabelle. 
Should be executed in the subdirectory LK.
*)

writeln"Root file for Classical Sequent Calculus";

print_depth 1;  

use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

structure LK_Syntax = LK_SyntaxFun();
structure LK_Rule = LK_RuleFun(LK_Syntax);
structure LK_Resolve = LK_ResolveFun(LK_Rule);

open LK_Rule LK_Resolve;
print_depth 8;  

(* Set up automatic printing of theorems -- works in Poly/ML only *)
install_pp (K print_thm);

