(*  Title: 	LK/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Rules for classical first-order sequent calculus 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature LK_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val basic: thm
  val thinR: thm
  val thinL: thm
  val cut: thm
  val conjR: thm
  val conjL: thm
  val disjR: thm
  val disjL: thm
  val impR: thm
  val impL: thm
  val notR: thm
  val notL: thm
  val iff_def: thm
  val allR: thm
  val allL: thm
  val exR: thm
  val exL: thm
  val refl: thm
  val sym: thm
  val trans: thm
  val The: thm
  end;


functor LK_RuleFun (LK_Syntax: LK_SYNTAX) : LK_RULE = 
struct

val thy = extend_theory pure_thy "LK"
( [("term",["logic"])],
  [],
  [(["o"], ([],"logic")),
   (["sequence","seqobj","seqcont","sequ","sobj"], ([],"any"))],
  LK_Syntax.const_decs,
  Some LK_Syntax.sext)
[
  (*Structural rules*)

  ("basic",   "$H, P, $G |- $E, P, $F"),

  ("thinR",  "$H |- $E, $F ==> $H |- $E, P, $F"),
  ("thinL",   "$H, $G |- $E ==> $H, P, $G |- $E"),

  ("cut",    "[| $H |- $E, P;  $H, P |- $E |] ==> $H |- $E"),

  (*Propositional rules*)

  ("conjR", "[| $H|- $E, P, $F;  $H|- $E, Q, $F |] ==> $H|- $E, P&Q, $F"),
  ("conjL",  "$H, P, Q, $G |- $E ==> $H, P & Q, $G |- $E"),

  ("disjR", "$H |- $E, P, Q, $F ==> $H |- $E, P|Q, $F"),
  ("disjL",
     "[| $H, P, $G |- $E;  $H, Q, $G |- $E |] ==> $H, P|Q, $G |- $E"),

  ("impR",  "$H, P |- $E, Q, $F ==> $H |- $E, P-->Q, $F"),
  ("impL","[| $H,$G |- $E,P;  $H, Q, $G |- $E |] ==> $H, P-->Q, $G |- $E"),

  ("notR",  "$H, P |- $E, $F ==> $H |- $E, ~P, $F"),
  ("notL",   "$H, $G |- $E, P ==> $H, ~P, $G |- $E"),

  ("iff_def",  "P<->Q == (P-->Q) & (Q-->P)"),

  (*Quantifiers*)

  ("allR",  "(!!x.$H |- $E, P(x), $F) ==> $H |- $E, ALL x.P(x), $F"),
  ("allL",  "$H, P(x), $G, ALL x.P(x) |- $E ==> $H, ALL x.P(x), $G |- $E"),

  ("exR",   "$H |- $E, P(x), $F, EX x.P(x) ==> $H |- $E, EX x.P(x), $F"),
  ("exL",   "(!!x.$H, P(x), $G |- $E) ==> $H, EX x.P(x), $G |- $E"),

  (*Equality*)

  ("refl",  "$H |- $E, a=a, $F"),
  ("sym",   "$H |- $E, a=b, $F ==> $H |- $E, b=a, $F"),
  ("trans", "[| $H|- $E, a=b, $F;  $H|- $E, b=c, $F |] ==> $H|- $E, a=c, $F"),


  (*Descriptions*)

  ("The", "[| $H |- $E, P(a), $F;  !!x.$H, P(x) |- $E, x=a, $F |] ==> \
\          $H |- $E, P(THE x.P(x)), $F")
];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val basic = ax"basic";
val thinR = ax"thinR";
val thinL = ax"thinL";
val cut = ax"cut";
val conjR = ax"conjR";
val conjL = ax"conjL";
val disjR = ax"disjR";
val disjL = ax"disjL";
val impR = ax"impR";
val impL = ax"impL";
val notR = ax"notR";
val notL = ax"notL";
val iff_def = ax"iff_def";
val allR = ax"allR";
val allL = ax"allL";
val exR = ax"exR";
val exL = ax"exL";
val refl = ax"refl";
val sym = ax"sym";
val trans = ax"trans";
val The = ax"The";
end;

