(*  Title: 	LCF/ruleshell
    Author: 	Tobias Nipkow
    Copyright   1992  University of Cambridge

Natural Deduction Rules for LCF

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"

*)

signature FOL_sig =
sig
  val thy: theory
end;


signature LCF_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val eq_def: thm
  val less_trans: thm
  val less_ext: thm
  val mono: thm
  val minimal: thm
  val FIX_eq: thm
  val tr_cases: thm
  val not_TT_less_FF: thm
  val not_FF_less_TT: thm
  val not_TT_less_UU: thm
  val not_FF_less_UU: thm
  val COND_UU: thm
  val COND_TT: thm
  val COND_FF: thm
  val surj_pairing: thm
  val FST: thm
  val SND: thm
  val void_cases: thm
  val induct: thm
  val adm_cong: thm
  val adm_less: thm
  val adm_not_less: thm
  val adm_not_free: thm
  val adm_subst: thm
  val adm_conj: thm
  val adm_disj: thm
  val adm_imp: thm
  val adm_all: thm
  end;


functor LCF_RuleFun (FOL:FOL_sig) : LCF_RULE = 
struct

local open Syntax
in

val mixfix =
[   (*Types*)
 TInfixl("*", "prod", 6),
    (*Terms*)
 Delimfix("()", "void", "VOID"),
 Mixfix("(1<_,/_>)", "['a,'b] => ('a,'b)prod", "PAIR", [], 100),
 Mixfix("(_ =>/ (_ |/ _))", "[tr,'a,'a] => 'a", "COND", [60,60,60], 60),
    (*Predicates*)
 Infixl("<<", "['a,'a] => o", 50)
];

val sext = Sext{mixfix=mixfix,
		parse_translation = [],
		print_translation = []};

val const_decs =
[(["UU"], "'a"),
 (["TT","FF"], "tr"),
 (["FIX"], "('a => 'a) => 'a"),
 (["FST"], "'a*'b => 'a"),
 (["SND"], "'a*'b => 'b"),
 (["adm"], "('a => o) => o")
];

end;

val thy = extend_theory FOL.thy "LCF"
([("cpo",["term"])],
 [(["fun"], (["cpo","cpo"],"cpo"))],
 [(["tr","void"], ([],"cpo")),
  (["prod"], (["cpo","cpo"],"cpo"))
 ],
 const_decs,
 Some(sext))
[
  (** DOMAIN THEORY **)

  ("eq_def", "x=y == x << y & y << x"),

  ("less_trans", "[| x << y; y << z |] ==> x << z"),

  ("less_ext", "(ALL x. f(x) << g(x)) ==> f << g"),

  ("mono", "[| f << g; x << y |] ==> f(x) << g(y)"),

  ("minimal", "UU << x"),

  ("FIX_eq", "f(FIX(f)) = FIX(f)"),

  (** TR **)

  ("tr_cases", "p=UU | p=TT | p=FF"),

  ("not_TT_less_FF", "~ TT << FF"),
  ("not_FF_less_TT", "~ FF << TT"),
  ("not_TT_less_UU", "~ TT << UU"),
  ("not_FF_less_UU", "~ FF << UU"),

  ("COND_UU", "UU => x | y  =  UU"),
  ("COND_TT", "TT => x | y  =  x"),
  ("COND_FF", "FF => x | y  =  y"),

  (** PAIRS **)

  ("surj_pairing", "<FST(z),SND(z)> = z"),

  ("FST", "FST(<x,y>) = x"),
  ("SND", "SND(<x,y>) = y"),

  (** VOID **)

  ("void_cases", "(x::void) = UU"),

  (** INDUCTION **)

  ("induct", "[| adm(P); P(UU); ALL x. P(x) --> P(f(x)) |] ==> P(FIX(f))"),

  (** Admissibility / Chain Completeness **)
  (* All rules can be found on pages 199--200 of Larry's LCF book.
     Note that "easiness" of types is not taken into account
     because it cannot be expressed schematically; flatness could be. *)

  ("adm_cong", "(!!x. P(x) <-> Q(x)) ==> adm(P) <-> adm(Q)"),
  (* Cannot be derived (?) because there is no subst rule for predicates *)

  ("adm_less",	     "adm(%x.t(x) << u(x))"),
  ("adm_not_less",   "adm(%x.~ t(x) << u)"),
  ("adm_not_free",   "adm(%x.A)"),
  ("adm_subst",	     "adm(P) ==> adm(%x.P(t(x)))"),
  ("adm_conj",	     "[| adm(P); adm(Q) |] ==> adm(%x.P(x)&Q(x))"),
  ("adm_disj",	     "[| adm(P); adm(Q) |] ==> adm(%x.P(x)|Q(x))"),
  ("adm_imp",	     "[| adm(%x.~P(x)); adm(Q) |] ==> adm(%x.P(x)-->Q(x))"),
  ("adm_all",	     "(!!y.adm(P(y))) ==> adm(%x.ALL y.P(y,x))")

];

val sign = sign_of thy;

val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val eq_def = ax"eq_def";
val less_trans = ax"less_trans";
val less_ext = ax"less_ext";
val mono = ax"mono";
val minimal = ax"minimal";
val FIX_eq = ax"FIX_eq";
val tr_cases = ax"tr_cases";
val not_TT_less_FF = ax"not_TT_less_FF";
val not_FF_less_TT = ax"not_FF_less_TT";
val not_TT_less_UU = ax"not_TT_less_UU";
val not_FF_less_UU = ax"not_FF_less_UU";
val COND_UU = ax"COND_UU";
val COND_TT = ax"COND_TT";
val COND_FF = ax"COND_FF";
val surj_pairing = ax"surj_pairing";
val FST = ax"FST";
val SND = ax"SND";
val void_cases = ax"void_cases";
val induct = ax"induct";
val adm_cong = ax"adm_cong";
val adm_less = ax"adm_less";
val adm_not_less = ax"adm_not_less";
val adm_not_free = ax"adm_not_free";
val adm_subst = ax"adm_subst";
val adm_conj = ax"adm_conj";
val adm_disj = ax"adm_disj";
val adm_imp = ax"adm_imp";
val adm_all = ax"adm_all";

end;
