(*  Title: 	HOL/ex/wf.ML
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Well-founded Recursion
*)

structure WF =
struct

val thy = extend_theory Sum.thy "WF_Rec"
 ([],[],[],
  [(["wf","trans"], 	"('a * 'a)class => bool"),
   (["cut"], 		"['a => 'b, ('a * 'a)class, 'a] => 'a => 'b"),
   (["wfrec"], 	"[('a * 'a)class, ('a=>'b)=>('a=>'b)] => 'a => 'b"),
   (["is_recfun"], 
    "[('a * 'a)class, ('a=>'b)=>('a=>'b), 'a=>'b, 'a] => bool"),
   (["the_recfun"], 
    "[('a * 'a)class, ('a=>'b)=>('a=>'b), 'a] => 'a=>'b")
  ],
  None)
 [
  ("wf_def",
	 "wf(r) == (!P. (!x. (!y. <y,x>:r --> P(y)) --> P(x)) --> (!x.P(x)))"),
  ("trans_def", "trans(r) == (!x y z. <x,y>:r --> <y,z>:r --> <x,z>:r)"),
  ("cut_def", 	"cut(f,r,x) == (%y. <y,x>:r => f(y) | (@z.True))"),
  ("is_recfun_def", "is_recfun(r,H,f,a) == (f=cut((%x.H(cut(f,r,x),x)),r,a))"),
  ("the_recfun_def", "the_recfun(r,H,a) == (@f.is_recfun(r,H,f,a))"),
  ("wfrec_def", "wfrec(r,H,a) == H(the_recfun(r,H,a),a)")
 ];
end;

local val ax = get_axiom WF.thy
in
val wf_def = ax "wf_def";
val trans_def = ax "trans_def";
val cut_def = ax "cut_def";
val wfrec_def = ax "wfrec_def";
val is_recfun_def = ax "is_recfun_def";
val the_recfun_def = ax "the_recfun_def";
end;

val H_cong = hd(mk_typed_congs WF.thy [("H","[?'a=>?'b,?'a]=>?'b")]);
val H_cong2 = refl RSN (2,H_cong);

val ssw = HOL_ss addcongs (H_cong::mk_congs WF.thy ["cut"]);

val major::prems = goalw WF.thy [wf_def]
    "[| wf(r);          \
\       !!x.[| ! y. <y,x>: r --> P(y) |] ==> P(x) \
\    |]  ==>  P(a)";
br (major RS spec RS mp RS spec) 1;
by (fast_tac (HOL_cs addEs prems) 1);
val wf_induct = result();

(*Perform induction on i, then prove the wf(r) subgoal using prems. *)
fun wf_ind_tac a prems i = 
    EVERY [res_inst_tac [("a",a)] wf_induct i,
	   rename_last_tac a ["1"] (i+1),
	   ares_tac prems i];

val prems = goal WF.thy "[| wf(r);  <a,x>:r;  <x,a>:r |] ==> P";
by (subgoal_tac "! x. <a,x>:r --> <x,a>:r --> P" 1);
by (fast_tac (HOL_cs addIs prems) 1);
by (wf_ind_tac "a" prems 1);
by (fast_tac class_cs 1);
val wf_anti_sym = result();

val prems = goal WF.thy "[| wf(r);  <a,a>: r |] ==> P";
br wf_anti_sym 1;
by (REPEAT (resolve_tac prems 1));
val wf_anti_refl = result();



(** Natural deduction for trans(r) **)

val prems = goalw WF.thy [trans_def]
    "(!! x y z. [| <x,y>:r;  <y,z>:r |] ==> <x,z>:r) ==> trans(r)";
by (REPEAT (ares_tac (prems@[allI,impI]) 1));
val transI = result();

val major::prems = goalw WF.thy [trans_def]
    "[| trans(r);  <a,b>:r;  <b,c>:r |] ==> <a,c>:r";
by (cut_facts_tac [major] 1);
by (fast_tac (HOL_cs addIs prems) 1);
val transD = result();

val trans_tac = EVERY'[etac transD, atac, atac];

(** cut **)

goalw WF.thy [cut_def]
    "(cut(f,r,x) = cut(g,r,x)) = (!y. <y,x>:r --> f(y)=g(y))";
by (SIMP_CASE_TAC (ssw addrews [expand_fun_eq]) 1);
val cut_cut_eq = result();
val ssw = ssw addrews [cut_cut_eq];


(** is_recfun Lemmas **)

auto_tac_ref := (rtac truth ORELSE' trans_tac);

val prems = goalw WF.thy [is_recfun_def,cut_def]
    "[| wf(r); trans(r); is_recfun(r,H,f,a); is_recfun(r,H,g,b) |] ==> \
    \ <x,a>:r --> <x,b>:r --> f(x)=g(x)";
by (EVERY1 [cut_facts_tac prems, etac wf_induct, strip_tac,
	    etac ssubst, etac ssubst,
	    ASM_SIMP_TAC ssw,
	    rtac (abs RS H_cong2), 
	    ASM_SIMP_CASE_TAC ssw]);
val is_recfun_equal = result() RS mp RS mp;

val prems = goalw WF.thy [is_recfun_def,cut_def]
    "[| is_recfun(r,H,f,a);  ~<b,a>:r |] ==> f(b) = (@z.True)";
by (cut_facts_tac prems 1);
by (etac ssubst 1);
by (ASM_SIMP_TAC ssw 1);
val is_recfun_undef = result();

val prems as [a1,a2,a3,a4,_] = goalw WF.thy [cut_def]
    "[| wf(r);  trans(r); \
\       is_recfun(r,H,f,a);  is_recfun(r,H,g,b);  <b,a>:r |] ==> \
\    cut(f,r,b) = g";
by (EVERY1 [cut_facts_tac prems, 
	    rtac abs,
	    ASM_SIMP_CASE_TAC(ssw addrews [a4 RS is_recfun_undef,
		a4 RS (a3 RS (a2 RS (a1 RS is_recfun_equal)))])]);
val is_recfun_cut = result();

(*** Main Existence Lemma ***)

val [major] = goal WF.thy
    "!x. P(x) --> (? y. Q(x,y)) ==> ? CF. !x. P(x) --> Q(x,CF(x))";
by (cut_facts_tac [major] 1);
by (fast_tac (HOL_cs addEs [selectI]) 1);
val all_ex_imp_ex_fun = result();

val prems = goal WF.thy "[| wf(R); trans(R) |] ==> ? f.is_recfun(R,H,f,a)";
by (cut_facts_tac prems 1);
by (wf_ind_tac "a" prems 1);
be (all_ex_imp_ex_fun RS exE) 1;
bw is_recfun_def;
by (res_inst_tac [("x", "cut(%z.H(y(z),z),R,a1)")] exI 1);
by (SIMP_TAC ssw 1);
by (EVERY1 [strip_tac, rtac H_cong2, rtac allE, atac, 
	    etac impE, atac, etac ssubst]);
by (fold_tac [is_recfun_def]);
by (ASM_SIMP_TAC (ssw addrews (prems RL [is_recfun_cut])) 1);
bw cut_def;
by (ASM_SIMP_CASE_TAC ssw 1);
by (fast_tac (HOL_cs addIs (prems RL [transD])) 1);
val ex_is_recfun = result();

auto_tac_ref := (rtac truth);

(** Unfolding the_recfun **)

val prems = goalw WF.thy [the_recfun_def]
    "[| wf(r); trans(r) |] ==> is_recfun(r, H, the_recfun(r,H,a), a)";
by (rtac (ex_is_recfun RS ex_selectI) 1);
by (REPEAT(resolve_tac prems 1));
val unfold_the_recfun = result();

(** the_recfun Lemmata **)

val prems = goalw WF.thy [the_recfun_def]
     "[| !!f. is_recfun(r,H,f,a) ==> P(f);  wf(r);  trans(r) |] ==> \
\     P(the_recfun(r,H,a))";
by (rtac (ex_is_recfun RS exE) 1 THEN REPEAT (resolve_tac prems 1));
(*incompleteness of unification?  should not require instantiation!*)
by (eres_inst_tac [("P", "%f. is_recfun(r,H,f,a)")] selectI 1);
val the_recfunI = result();

val prems = goal WF.thy
    "[| wf(r);  trans(r);  <a,b>:r |] ==> the_recfun(r,H,a,b) = (@z.True)";
br the_recfunI 1;
be is_recfun_undef 1;
by (REPEAT (ares_tac (prems@[notI,wf_anti_sym]) 1));
val the_recfun_undef = result();

val prems = goal WF.thy
    "[| wf(r); trans(r); <c,a>:r; <c,b>:r |] \
\    ==> the_recfun(r,H,a,c) = the_recfun(r,H,b,c)";
br the_recfunI 1;
br the_recfunI 1;
(*the RL seems necessary because of incompleteness of unif...*)
brs (prems RL [is_recfun_equal]) 1;
by (REPEAT (ares_tac prems 1));
val the_recfun_equal = result();

val prems = goal WF.thy
    "[| wf(r); trans(r); <b,a>:r |] \
\    ==> cut(the_recfun(r,H,a),r,b) = the_recfun(r,H,b)";
br the_recfunI 1;
br the_recfunI 1;
by (REPEAT (ares_tac (prems@[is_recfun_cut]) 1));
val the_recfun_cut = result();

(*** Unfolding wfrec ***)

val prems = goalw WF.thy [wfrec_def]
    "[| wf(r); trans(r) |] ==> wfrec(r,H,a) = H(cut(wfrec(r,H),r,a),a)";
by (EVERY1 [cut_facts_tac prems, 
	    stac (rewrite_rule [is_recfun_def] unfold_the_recfun),
	    REPEAT o atac, rtac H_cong2]);
by (rewrite_goals_tac [wfrec_def]);
by (ASM_SIMP_TAC (ssw addrews (prems RL [the_recfun_cut])) 1);
val wfrec_conv = result();

(*This form avoids giant explosions in proofs.  NOTE USE OF == *)
val [prem1,prem2,rew] = goal WF.thy
    "[| wf(r);  trans(r);  !!x. f(x)==wfrec(r,H,x) |] ==> \
\    f(a) = H(%y. <y,a> : r => f(y) | (@z. True),  a)";
bw rew;
by (fold_goals_tac [cut_def]);
by (REPEAT (resolve_tac [prem1,prem2,wfrec_conv] 1));
val wfrec_def_conv = result();

val prems = goal WF.thy
    "[| wf(r); trans(r); !f a. H(cut(f,r,a),a) = H(f,a) |] ==> \
\		wfrec(r,H) = H(wfrec(r,H))";
by (EVERY1 [cut_facts_tac prems, rtac abs, rtac trans, rtac wfrec_conv,
	  atac, atac, ASM_SIMP_TAC ssw]);
val wfrec_conv2 = result();
