(*  Title: 	HOL/ex/simult
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Primitives for simultaneous recursive type definitions
  includes worked example of trees & forests

This is essentially the same data structure that on ex/term.ML, which is
simpler because it uses List as a new type former.  The approach in this
file may be superior for other simultaneous recursions.

Recursion not done yet!!
*)

structure Simult =
struct
val thy = extend_theory Univ.thy "forest"
([], [], 
 [(["tree","forest"], (["term"],"term"))],
 [ 
  (["TF"],		"(('a+nat)sexp)class"),
  (["Rep_Tree"], 	"'a tree => ('a+nat)sexp"),
  (["Abs_Tree"], 	"('a+nat)sexp => 'a tree"),
  (["Rep_Forest"], 	"'a forest => ('a+nat)sexp"),
  (["Abs_Forest"], 	"('a+nat)sexp => 'a forest"),
  (["Label"],		"['a, 'a forest] => 'a tree"),
  (["Consf"],		"['a tree, 'a forest] => 'a forest"),
  (["Nilf"],		"'a forest"),
  (["OUT0","OUT1"],	"(('a+nat)sexp)class => (('a+nat)sexp)class")
 ],
 None)
 [ 
    (*operator for selecting out the various types*)
  ("OUT0_def",	"OUT0(s) == {x. EX z: s. z = IN0(x)}" ),
  ("OUT1_def", 	"OUT1(s) == {x. EX z: s. z = IN1(x)}" ),

  ("TF_def",	"TF == lfp(%Z.  range(ATOM) <*> OUT1(Z) \
\                           <+> ({NUMB(0)} <+> OUT0(Z) <*> OUT1(Z)))" ),
    (*faking a type definition for tree...*)
  ("Rep_Tree", 		"Rep_Tree(n): OUT0(TF)"),
  ("Rep_Tree_inverse", 	"Abs_Tree(Rep_Tree(t)) = t"),
  ("Abs_Tree_inverse", 	"z: OUT0(TF) ==> Rep_Tree(Abs_Tree(z)) = z"),
    (*faking a type definition for forest...*)
  ("Rep_Forest", 	"Rep_Forest(n): OUT1(TF)"),
  ("Rep_Forest_inverse", "Abs_Forest(Rep_Forest(ts)) = ts"),
  ("Abs_Forest_inverse", "z: OUT1(TF) ==> Rep_Forest(Abs_Forest(z)) = z"),
     (*defining the abstract constants*)
  ("Label_def",	"Label(a,ts) == Abs_Tree(ATOM(a) . Rep_Forest(ts))" ),
  ("Nilf_def", 	"Nilf        == Abs_Forest(IN0(NUMB(0)))" ),
  ("Consf_def",	
   "Consf(t,ts) == Abs_Forest(IN1(Rep_Tree(t) . Rep_Forest(ts)))" )
 ];
end;

local val ax = get_axiom Simult.thy
in 
val OUT0_def    = ax"OUT0_def";
val OUT1_def    = ax"OUT1_def";
val TF_def      = ax"TF_def";
val Rep_Tree    = ax"Rep_Tree";
val Rep_Tree_inverse    = ax"Rep_Tree_inverse";
val Abs_Tree_inverse    = ax"Abs_Tree_inverse";
val Rep_Forest  = ax"Rep_Forest";
val Rep_Forest_inverse  = ax"Rep_Forest_inverse";
val Abs_Forest_inverse  = ax"Abs_Forest_inverse";
val Label_def   = ax"Label_def";
val Nilf_def    = ax"Nilf_def";
val Consf_def   = ax"Consf_def";
end;


(*** General rules for OUT0 and OUT1 ***)

val prems = goalw Simult.thy [OUT0_def] "IN0(a) : s ==> a : OUT0(s)";
by (REPEAT (resolve_tac (prems@[refl,bexI,CollectI]) 1));
val OUT0I = result();

val [major] = goalw Simult.thy [OUT0_def] "a : OUT0(s) ==> IN0(a) : s";
br (major RS CollectD RS bexE) 1;
be subst 1;
ba 1;
val OUT0D = result();

val OUT0E = make_elim OUT0D;

val prems = goalw Simult.thy [OUT1_def] "IN1(a) : s ==> a : OUT1(s)";
by (REPEAT (resolve_tac (prems@[refl,bexI,CollectI]) 1));
val OUT1I = result();

val [major] = goalw Simult.thy [OUT1_def] "a : OUT1(s) ==> IN1(a) : s";
br (major RS CollectD RS bexE) 1;
be subst 1;
ba 1;
val OUT1D = result();

val OUT1E = make_elim OUT1D;

val [prem] = goal Simult.thy "B<=C ==> OUT0(B) <= OUT0(C)";
by (REPEAT (eresolve_tac [OUT0E, prem RS subsetD] 1
     ORELSE ares_tac [subsetI,OUT0I] 1));
val OUT0_mono = result();

val [prem] = goal Simult.thy "B<=C ==> OUT1(B) <= OUT1(C)";
by (REPEAT (eresolve_tac [OUT1E, prem RS subsetD] 1
     ORELSE ares_tac [subsetI,OUT1I] 1));
val OUT1_mono = result();


(*** Monotonicity and unfolding of the function ***)

goal Simult.thy "mono(%Z.  range(ATOM) <*> OUT1(Z) \
\                      <+> ({NUMB(0)} <+> OUT0(Z) <*> OUT1(Z)))";
by (REPEAT (ares_tac [monoI, subset_refl, usum_mono, uprod_mono,
		      OUT0_mono, OUT1_mono] 1));
val TF_fun_mono = result();

val TF_unfold = TF_fun_mono RS (TF_def RS Tarski_def_theorem);


(** Elimination -- structural induction on the class TF **)

val major::prems = goalw Simult.thy [TF_def]
    "[| i: TF;  \
\       !!x zs. [| zs: OUT1(TF);  R(IN1(zs)) |] ==> R(IN0(ATOM(x) . zs)); \
\       R(IN1(IN0(NUMB(0))));        \
\       !!z zs. [| z:  OUT0(TF);  zs: OUT1(TF);  R(IN0(z));  R(IN1(zs)) \
\               |] ==> R(IN1(IN1(z.zs)))    \
\    |] ==> R(i)";
br (TF_fun_mono RS (major RS general_induction)) 1;
by (fast_tac (class_cs addIs (prems@[OUT0I,OUT1I])
		       addEs [usumE, uprodE, OUT0E, OUT1E]) 1);
val TF_induct = result();

(*This lemma replaces a use of subgoal_tac to prove tree_forest_induct*)
val [major] = goal Simult.thy
    "[| !!i. i: TF ==> \
\            (! x. i=IN0(x) --> P(x)) & (! y. i=IN1(y) --> Q(y))    \
\    |] ==> (ALL z: OUT0(TF). P(z)) & (ALL zs: OUT1(TF). Q(zs))";
by (fast_tac (class_cs addEs ([OUT0E, OUT1E] @ [major RS conjE])) 1);
val TF_induct_lemma = result();

val uplus_cs = class_cs addEs [make_elim IN0_inject, make_elim IN1_inject, 
			       IN0_neq_IN1, IN1_neq_IN0];

(*Induction on TF with separate predicates P, Q*)
val prems = goal Simult.thy
    "[| !!x zs. [| zs: OUT1(TF);  Q(zs) |] ==> P(ATOM(x) . zs); \
\       Q(IN0(NUMB(0)));        \
\       !!z zs. [| z:  OUT0(TF);  zs: OUT1(TF);  P(z);  Q(zs) \
\               |] ==> Q(IN1(z.zs))     \
\    |] ==> (ALL z: OUT0(TF). P(z)) & (ALL zs: OUT1(TF). Q(zs))";
br TF_induct_lemma 1;
be TF_induct 1;
by (REPEAT (fast_tac (uplus_cs addIs prems) 1));
val Tree_Forest_induct = result();

(*Induction for the abstract types 'a tree, 'a forest*)
val prems = goalw Simult.thy [Label_def,Nilf_def,Consf_def]
    "[| !!x ts. Q(ts) ==> P(Label(x,ts));     \
\	Q(Nilf);        \
\       !!t ts. [| P(t);  Q(ts) |] ==> Q(Consf(t,ts))    \
\    |] ==> (! t. P(t)) & (! ts. Q(ts))";
by (res_inst_tac [("P1","%z.P(Abs_Tree(z))"),
		  ("Q1","%z.Q(Abs_Forest(z))")] 
    (Tree_Forest_induct RS conjE) 1);
by (REPEAT (ares_tac prems 1
     ORELSE eresolve_tac [Abs_Tree_inverse RS subst,
                          Abs_Forest_inverse RS subst] 1));
br conjI 1;
by (rtac (Rep_Tree_inverse RS subst RS allI) 1);
by (rtac (Rep_Forest_inverse RS subst RS allI) 2);
by (REPEAT (resolve_tac [Rep_Tree,Rep_Forest] 1 ORELSE etac bspec 1));
val tree_forest_induct = result();



(*** Isomorphisms ***)

goal Simult.thy "One_One(Rep_Tree)";
br One_One_inverseI 1;
br Rep_Tree_inverse 1;
val One_One_Rep_Tree = result();

goal Simult.thy "One_One(Rep_Forest)";
br One_One_inverseI 1;
br Rep_Forest_inverse 1;
val One_One_Rep_Forest = result();

goal Simult.thy "One_One_on(Abs_Forest,OUT1(TF))";
br One_One_on_inverseI 1;
be Abs_Forest_inverse 1;
val One_One_on_Abs_Forest = result();

(** Distinctness of constructors **)

(* ?c : range(ATOM) <*> OUT1(TF) 
        <+> {NUMB(0)} <+> OUT0(TF) <*> OUT1(TF) ==>   ?c : TF *)
val TF_I = TF_unfold RS equalityD2 RS subsetD;

goalw Simult.thy [Nilf_def,Consf_def] "~ Consf(x,xs) = Nilf";
br (IN1_not_IN0 RS (One_One_on_Abs_Forest RS One_One_on_contraD)) 1;
by (REPEAT (resolve_tac [rangeI, singletonI, Rep_Tree, Rep_Forest, 
			 OUT1I, TF_I, uprodI, usum_IN0I, usum_IN1I] 1));
val Consf_not_Nilf = result();

val Consf_neq_Nilf = standard (Consf_not_Nilf RS notE);;
val Nilf_neq_Consf = sym RS Consf_neq_Nilf;

(** Injectiveness of Consf **)

val [major,minor] = goalw Simult.thy [Consf_def]
    "[| Consf(x,xs)=Consf(y,ys);  [| x=y;  xs=ys |] ==> P \
\    |] ==> P";
br (IN1_inject RS Scons_inject) 1;
br (major RS (One_One_on_Abs_Forest RS One_One_onD)) 1;
by (REPEAT (resolve_tac [Rep_Tree, Rep_Forest, rangeI, 
			 OUT1I, TF_I, uprodI, usum_IN1I] 1));
br minor 1;
by (REPEAT (eresolve_tac [One_One_Rep_Tree RS One_OneD, 
			  One_One_Rep_Forest RS One_OneD, ATOM_inject] 1));
val Consf_inject = result();
