(*  Title: 	HOL/ex/prop-log
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Inductive (impredicative) definition of propositional logic.
Soundness and completeness w.r.t. truth-tables.

*)

local open Syntax;

val mixfix =
[Mixfix("_ -> _", "[pl,pl] => pl", "pl_imp", [20,10],10),
 Delimfix("#_", "nat => pl", "var"),
 Delimfix("_ |- _", "[pl => bool, pl] => bool", "pl_der"),
 Delimfix("_ |= _", "[pl => bool, pl] => bool", "pl_val"),
 Mixfix("_[_]", "[nat => bool, pl] => bool", "eval", [100,0], 100)
];

val sext = Sext{mixfix=mixfix, parse_translation=[], print_translation=[]};

in

val pl_thy = extend_theory Arith.thy "Min Log" 
   ([], (* new sorts *)
    [], (* old types *)
    [(["pl"], ([],"term"))], (* new types *)
    [(["false"], "pl"),
     (["max"], "pl => nat"),
     (["tt_asms"], "[nat => bool, nat, pl] => bool")], (* constants *)
    Some sext)
[
("pl_der",
	"H |- p = (!D. (!H p. H(p) --> D(H,p)) --> \
\		       (!H p q. D(H,false->p)) --> \
\		       (!H p q. D(H,p->q->p)) --> \
\		       (!H p q r. D(H,(p->q->r) -> (p->q) -> p -> r)) --> \
\		       (!H p q r. D(H,((p->false) -> p) -> p)) --> \
\		       (!H p q. D(H,p -> q) --> D(H,p) --> D(H,q)) \
\		       --> D(H,p))"),

("pl_val", "H |= p  =  (!t. (!q. H(q) --> t[q]) --> t[p])"),

("eval_false", "t[false] = False"),
("eval_var", "t[#v] = t(v)"),
("eval_imp", "t[p->q] = (t[p]-->t[q])"),

("max_false", "max(false) = 0"),
("max_var", "max(#x) = Suc(x)"),
("max_imp", "max(p->q) = (max(p) < max(q) => max(q) | max(p))"),

("tt_asms_def",
 "tt_asms(t,k) == nat_rec(k, %p.False, \
\	                  %n H p. H(p) | (p = (t(n) => #n | (#n->false))))"),

("term_ind", "[| P(false); !!v. P(#v); !!p q. P(p)-->P(q)-->P(p->q)|] \
\	      ==> !t.P(t)")

];

val ax = get_axiom pl_thy;

val pl_der =  ax "pl_der";
val pl_val =  ax "pl_val";
val eval_false = ax "eval_false";
val eval_var = ax "eval_var";
val eval_imp = ax "eval_imp";
val max_false = ax "max_false";
val max_var = ax "max_var";
val max_imp = ax "max_imp";
val term_ind = ax "term_ind";
val tt_asms_def = ax "tt_asms_def";

end;

val ss = arith_ss 
    addcongs (mk_congs pl_thy ["max","var","pl_imp","tt_asms",
			       "pl_der","pl_val","eval"])
    addrews [not_less0,
	     eval_false,eval_var,eval_imp,max_false,max_var,max_imp];

val [prem] = goal pl_thy "H(p) ==> H |- p";
by (EVERY [stac pl_der 1, strip_tac 1, REPEAT(etac allE 1),
	 etac (prem RSN (2,impE)) 1, atac 1]);
val Asm = result();

val ax_tac = stac pl_der 1 THEN
	     REPEAT(ares_tac[impI,allI]1 ORELSE etac allE 1);

goal pl_thy "H |- false->p";
by ax_tac;
val ex_falso = result();

goal pl_thy "H |- p->q->p";
by ax_tac;
val K = result();

goal pl_thy "H |- (p->q->r) -> (p->q) -> p -> r";
by ax_tac;
val S = result();

goal pl_thy "H |- ((p->false)->p)->p";
by ax_tac;
val Peirce = result();

val prems = goal pl_thy "[| H |- p->q;  H |- p |] ==> H |- q";
by (cut_facts_tac (prems RL [pl_der RS iffD2]) 1);
by (stac pl_der 1);
by (fast_tac HOL_cs 1);
val MP = result();

val I = K RS (K RS (S RS MP) RS MP);
val ss = ss addrews [I];

val weaken = K RS MP;

fun cascade_tac _ =
EVERY [etac impE 1, etac impE 2, etac impE 3, etac impE 4,
      etac impE 5, etac impE 6, atac 7];

val [prem] = goal pl_thy "H |- p ==>  %x.H(x)|G(x) |- p";
br (prem RS (pl_der RS iffD2) RS allE) 1;
by (EVERY [cascade_tac 1, strip_tac 1,
	   rtac Asm 1, fast_tac HOL_cs 1,
	   fast_tac (HOL_cs addIs [ex_falso])1, 
	   fast_tac (HOL_cs addIs [K]) 1, 
	   fast_tac (HOL_cs addIs [S])1,
	   fast_tac (HOL_cs addIs [Peirce])1, fast_tac (HOL_cs addIs [MP])1]);
val weaken_HU = result();

val [major,minor] = goal pl_thy "[| G |- p; !! p. G(p) ==> H(p) |] ==> H |- p";
by (EVERY1 [subgoal_tac "H = (%p. G(p) | H(p))", etac ssubst, 
	  rtac (major RS weaken_HU), rtac abs, 
	  fast_tac (HOL_cs addIs [minor])]);
val weaken_H = result();

val [prem] = goal pl_thy "H |- b  ==> %x. H(x) & ~(x=a) |- a -> b";
br (prem RS (pl_der RS iffD2) RS allE) 1;
by (EVERY1 [cascade_tac, strip_tac,
	    res_inst_tac[("Q","p=a")]disj_cases, rtac excluded_middle,
	    rtac weaken, rtac Asm, fast_tac HOL_cs ,
	    etac ssubst, rtac I,
	    strip_tac, rtac (ex_falso RS weaken),
	    strip_tac, rtac (K RS weaken),
	    strip_tac, rtac (S RS weaken),
	    strip_tac, rtac (Peirce RS weaken),
	    strip_tac]);
by (REPEAT(ares_tac[S RS MP RS MP]1));
val ded_thm = result();

val [asm] = goal pl_thy "(%x. H(x) | x=p) |- q  ==>  H |- p -> q";
by (cut_facts_tac[asm RS ded_thm]1);
by (etac weaken_H 1);
by (fast_tac HOL_cs 1);
val Ded_thm = result();


goal pl_thy "H |- (p->q) -> ((p->false)->q) -> q";
by (EVERY1 [rtac Ded_thm, rtac Ded_thm, rtac MP, rtac Peirce, rtac Ded_thm,
	  rtac MP, rtac Asm, fast_tac HOL_cs, rtac Ded_thm, rtac MP, rtac Asm,
	  fast_tac HOL_cs , rtac MP, rtac Asm, rtac disjI1, rtac disjI1,
	  rtac disjI1, rtac disjI2, rtac refl, rtac Asm,
	  fast_tac HOL_cs ]);
val CCONTR = result();

val CCONTR_rule = Ded_thm RS (Ded_thm RSN (2,(CCONTR RS MP RS MP)));

writeln"Soundness of the rules wrt truth-table semantics";
goal pl_thy "H |- p --> H |= p";
by (EVERY1 [stac pl_der, rtac impI, stac pl_val,
	  rtac allI, etac allE, cascade_tac]);
by (REPEAT_FIRST (rtac allI));
by (EVERY1 [fast_tac HOL_cs, 
	  sstac[eval_imp,eval_false], fast_tac HOL_cs,
	  sstac[eval_imp,eval_imp], fast_tac HOL_cs,
	  sstac[eval_imp,eval_imp,eval_imp,eval_imp,eval_imp,eval_imp],
	  fast_tac HOL_cs, 
	  sstac[eval_imp,eval_imp,eval_imp,eval_false], fast_tac HOL_cs, 
	  stac eval_imp, fast_tac HOL_cs]);
result();


val tt_asms_0 = standard (tt_asms_def RS nat_rec_def_0_conv)
and tt_asms_suc = standard (tt_asms_def RS nat_rec_def_Suc_conv);

val ss = ss addrews [tt_asms_0,tt_asms_suc];

goal pl_thy "!n. m<n --> tt_asms(t,m,p) --> tt_asms(t,n,p)";
by (ALL_IND_TAC nat_ind (SIMP_TAC (ss addrews [less_Suc_eq])) 1);
val tt_asms_mon_lemma = result();

val [prem] = goal pl_thy "m < n | m=n ==> tt_asms(t,m,p) --> tt_asms(t,n,p)";
by (EVERY1 [rtac (prem RSN(1,disjE)), 
	  etac (tt_asms_mon_lemma RS spec RS mp), 
	  etac ssubst,
	  fast_tac HOL_cs ]);
val tt_asms_mon = result() RS mp;

goal pl_thy "max(p) < max(p->q) | max(p) = max(p->q)";
by (SIMP_CASE_TAC ss 1);
val max_imp_mon1 = result();

goal pl_thy "max(q) < max(p->q) | max(q) = max(p->q)";
by (SIMP_CASE_TAC (ss addrews [not_less_eq, less_Suc_eq]) 1);
val max_imp_mon2 = result();

goal pl_thy "!p. tt_asms(t,max(p)) |- t[p] => p | (p->false)";
by (rtac term_ind 1);
by (SIMP_TAC ss 1);
by (SIMP_CASE_TAC (ss addrews [Asm]) 1);
by (EVERY1 [sstac[eval_imp,expand_if], rtac conjI,
	 stac expand_if, rtac conjI, strip_tac]);
by (EVERY1 [rtac Ded_thm, etac weaken_H, rtac disjI1,
	  rtac (max_imp_mon2 RS tt_asms_mon), atac]);
by (EVERY1 [stac expand_if, rtac conjI, fast_tac HOL_cs, strip_tac]);
by (EVERY1 [rtac Ded_thm, rtac MP, rtac ex_falso, rtac MP,
	  etac weaken_H, rtac disjI1,
	  rtac (max_imp_mon1 RS tt_asms_mon), atac,
	  rtac Asm, rtac (refl RS disjI2)]);
by (EVERY1 [stac expand_if, rtac conjI, fast_tac HOL_cs,
	  stac expand_if, rtac conjI]);
by (fast_tac HOL_cs 2);
by (EVERY1 [strip_tac, rtac Ded_thm, rtac MP, etac weaken_H,
	    rtac disjI1, rtac (max_imp_mon2 RS tt_asms_mon), atac,
	    rtac MP, rtac Asm, rtac (refl RS disjI2), etac weaken_H,
	    rtac disjI1, rtac (max_imp_mon1 RS tt_asms_mon), atac]);
val lemma0 = result() RS spec;

val [valid] = goal pl_thy "(!t.t[p]) ==> tt_asms(t,max(p)) |- p";
by (EVERY1 [rtac (lemma0 RSN (2,mp)), sstac[valid RS spec RS eqTrueI],
	    SIMP_TAC ss]);
val lemma = result();

goal pl_thy
	"!n. (!i. i<n --> t1(i)=t2(i)) --> tt_asms(t1,n,p) = tt_asms(t2,n,p)";
by (ALL_IND_TAC nat_ind (SIMP_TAC (ss addrews [less_Suc_eq])) 1);
val tt_asms_limit = result() RS spec RS mp RS abs;

goal pl_thy "tt_asms(%n.t(n) | n=m,m) = tt_asms(t,m)";
by (EVERY1 [rtac tt_asms_limit, strip_tac, 
	    cut_facts_tac [less_not_refl],
	    fast_tac HOL_cs]);
val tt_asms_lemma1 = result();

goal pl_thy "tt_asms(%n.t(n) & ~(n=m),m) = tt_asms(t,m)";
by (EVERY1 [rtac tt_asms_limit, strip_tac, 
	    cut_facts_tac [less_not_refl],
	    fast_tac HOL_cs]);
val tt_asms_lemma2 = result();

val [valid] = goal pl_thy "!t.t[p] ==> !t. tt_asms(t,0) |- p";
by (rtac zero_induct 1);
by (rtac (valid RS lemma RS allI) 1);
by (rtac (tt_asms_suc RS abs RS ssubst RS allI) 1);
by (rtac CCONTR_rule 1);
by (eres_inst_tac[("x","%i. t(i) | i=n")] allE 1);
by (EVERY [rtac mp 1, atac 2, SIMP_TAC (ss addrews [tt_asms_lemma1]) 1]);
by (eres_inst_tac[("x","%i. t(i) & ~(i=n)")] allE 1);
by (EVERY [rtac mp 1, atac 2, SIMP_TAC (ss addrews [tt_asms_lemma2]) 1]);
val comp_lemma = result();

writeln"Completeness of inference rules wrt truth tables:";
goal pl_thy "%x.False |= p --> %x.False |- p";
by (EVERY1 [stac pl_val, rtac impI, stac (tt_asms_0 RS sym),
	    fast_tac (HOL_cs addIs [comp_lemma RS spec])]);
result();
