(*  Title: 	HOL/equalities
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Equalities involving union, intersection, inclusion, etc.
*)

writeln"File HOL/equalities";

(** Absorptive laws of Int and Un **)

goal Class.thy "A Int A = A";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_absorb = result();

goal Class.thy "A Un A = A";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_absorb = result();

val prems = goal Class.thy "A<=B ==> A Un B = B";
by (cut_facts_tac prems 1);
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_absorb_subsetI = result();

val prems = goal Class.thy "A Un B = B  ==>  A<=B";
by (cfast_tac prems 1);
val Un_absorb_subsetD = result();

val prems = goal Class.thy "A<=B ==> A Int B = A";
by (cut_facts_tac prems 1);
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_absorb_subsetI = result();

val prems = goal Class.thy "A Int B = A  ==>  A<=B";
by (cfast_tac prems 1);
val Int_absorb_subsetD = result();

(** Simple properties of Compl -- complement of a class **)

goal Class.thy "A Int Compl(A) = {x.False}";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Compl_disjoint = result();

goal Class.thy "A Un Compl(A) = {x.True}";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Compl_partition = result();

goal Class.thy "Compl(Compl(A)) = A";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val double_complement = result();

(** Commutative laws of Int and Un **)

goal Class.thy "A Int B  =  B Int A";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_commute = result();

goal Class.thy "A Un B  =  B Un A";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_commute = result();

(** Associative laws of Int and Un **)

goal Class.thy "(A Int B) Int C  =  A Int (B Int C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_assoc = result();

goal Class.thy "(A Un B) Un C  =  A Un (B Un C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_assoc = result();


(** Distributive laws of Int and Un **)

goal Class.thy "(A Int B) Un C  =  (A Un C) Int (B Un C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_Int_distrib = result();

goal Class.thy "(A Un B) Int C  =  (A Int C) Un (B Int C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_Un_distrib = result();

goal Class.thy
 "(A Int B) Un (B Int C) Un (C Int A) = (A Un B) Int (B Un C) Int (C Un A)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_Un_crazy = result();

goal Class.thy "Compl(A Un B) = Compl(A) Int Compl(B)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val ComplUn = result();

goal Class.thy "Compl(A Int B) = Compl(A) Un Compl(B)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val ComplInt = result();


(*Both directions of Halmos, Naive Set Theory, page 16.*)

val prems = goal Class.thy "C<=A ==> (A Int B) Un C = A Int (B Un C)";
by (cut_facts_tac prems 1);
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_Un_assocI = result();

val [major] = goal Class.thy "(A Int B) Un C = A Int (B Un C)  ==>  C<=A";
br (major RS equalityE) 1;
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_Un_assocD = result();


(** Big Union and Intersection **)

goal Class.thy "Union(A Un B) = Union(A) Un Union(B)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Union_Un_distrib = result();

val [prem] = goal Class.thy
   "(!!B. B:C ==> B Int A = {x.False})  ==>  Union(C) Int A = {x.False}";
by (fast_tac (class_cs addIs [subset_antisym,
			      prem RS equalityD1 RS subsetD RS CollectD]) 1);
val Union_disjointI = result();

val prems = goal Class.thy
   "[| Union(C) Int A = {x.False};  B:C |] ==> B Int A = {x.False}";
by (cut_facts_tac prems 1);
by (etac equalityE 1);
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Union_disjointD = result();

goal Class.thy "Inter(A Un B) = Inter(A) Int Inter(B)";
by (best_tac (class_cs addIs [subset_antisym]) 1);
val Inter_Un_distrib = result();

(** Unions and Intersections of Families **)

goal Class.thy "(UN x:A. B(x)) = Union({Y. EX x:A. Y=B(x)})";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val UN_eq = result();

(*Look: it has EX and not ALL!*)
goal Class.thy "(INT x:A. B(x)) = Inter({Y. EX x:A. Y=B(x)})";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val INT_eq = result();

goal Class.thy "A Int Union(B) = (UN C:B. A Int C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Int_Union_image = result();

(* Devlin, page 12: Union of a family of unions **)
goal Class.thy "(UN x:C. A(x) Un B(x)) = Union(A``C)  Un  Union(B``C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_Union_image = result();

goal Class.thy "A Un Inter(B) = (INT C:B. A Un C)";
by (fast_tac (class_cs addIs [subset_antisym]) 1);
val Un_Inter_image = result();

goal Class.thy "(INT x:C. A(x) Int B(x)) = Inter(A``C) Int Inter(B``C)";
by (best_tac (class_cs addIs [subset_antisym]) 1);
val Int_Inter_image = result();
