(*  Title: 	FOL/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Natural Deduction Rules for Intuitionistic first-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature INT_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor Int_RuleFun () : INT_RULE = 
struct

local open Syntax
in

val mixfix =
 [    (*Propositions*)
  Mixfix("(_)",	"o => prop",	"Trueprop", [0], 5),
      (*Connectives*)
  Infixl("=",	"['a,'a] => o",			50),
  Mixfix("~_",	"o => o",	"Not",	[40],	40),
  Infixr("&",	"[o,o] => o",			35),
  Infixr("|",	"[o,o] => o",			30),
  Infixr("-->",	"[o,o] => o",			25),
  Infixr("<->",	"[o,o] => o",			25),
      (*Quantifiers*)
  Binder("ALL ", "'a", "o", "o", "All", 0, 	10),
  Binder("EX ",  "'a", "o", "o", "Ex", 0, 	10),
  Binder("EX! ", "'a", "o", "o", "Ex1", 0, 	10) ];

val sext = Sext{mixfix=mixfix,
		parse_translation = [],
		print_translation = []};

val const_decs =
 [ (["True","False"],	"o"),
      (*Rewriting gadgets*)
   (["NORM"],		"o => o"),
   (["norm"],		"'a => 'a") ];

end;


val thy = extend_theory pure_thy "FOL"
([("term",["logic"])],
 [],
 [(["o"], ([],"logic"))],
 const_decs,
 Some(sext))
[
  (*Equality*)

  ("refl",   "a=a"  ),
  ("subst",  "[| a=b;  P(a) |] ==> P(b)"),

  (*Propositional logic*)

  ("conjI",  "[| P;  Q |] ==> P&Q"  ),
  ("conjunct1", "P&Q ==> P"),
  ("conjunct2", "P&Q ==> Q"),

  ("disjI1",   "P ==> P|Q"  ),
  ("disjI2",   "Q ==> P|Q"  ),
  ("disjE",    "[| P|Q;  P ==> R;  Q ==> R |] ==> R"),

  ("impI",  "(P ==> Q) ==> P-->Q"),
  ("mp", "[| P-->Q;  P |] ==> Q"),

  ("FalseE",   "False ==> P" ),

  (*Definitions*)

  ("True_def",  "True == False-->False"),
  ("not_def", 	"~P == P-->False"),
  ("iff_def",   "P<->Q == (P-->Q) & (Q-->P)"),

  (*Unique existence*)
  ("ex1_def",   "EX! x. P(x) == EX x. P(x) & (ALL y. P(y) --> y=x)"  ),

  (*Quantifiers*)

  ("allI",  "(!!x. P(x)) ==> (ALL x.P(x))"  ),
  ("spec", "(ALL x.P(x)) ==> P(x)"  ),

  ("exI",  "P(x) ==> (EX x.P(x))"  ),
  ("exE",  "[| EX x.P(x);  !!x. P(x) ==> R |] ==> R"  ),

  (*Rewriting -- special constants to flag normalized terms and formulae*)
  ("norm_eq", 	"norm(x) = x"),
  ("NORM_iff", 	"NORM(P) <-> P")
];

val sign = sign_of thy;
val ax = get_axiom thy;
(*INSERT-RULENAMES -- file produced by make-rulenames*)

end;
