(*  Title: 	FOL/ex/prolog
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

First-Order Logic: PROLOG examples
*)

writeln"File FOL/ex/prolog.";

val prolog_thy = extend_theory Int_Rule.thy "prolog"
  ([],
   [],
   [(["list"], (["term"],"term"))], 
   [ (["Nil"],      "'a list"),
     (["Cons"],     "['a, 'a list] => 'a list"),
     (["append"],   "['a list, 'a list, 'a list] => o"),
     (["reverse"],  "['a list, 'a list] => o") ],
   None)
   [ 
     ("appnil",
	"append(Nil,ys,ys)"),
     ("appcons", 
	"append(xs,ys,zs) ==> append(Cons(x,xs), ys, Cons(x,zs))"),
     ("revnil",
	"reverse(Nil,Nil)"),
     ("revcons", 
	"[| reverse(xs,ys);  append(ys, Cons(x,Nil), zs) |] ==>  \
\         reverse(Cons(x,xs), zs)") 
   ];


val appnil = get_axiom prolog_thy "appnil";
val appcons = get_axiom prolog_thy "appcons";
val revnil = get_axiom prolog_thy "revnil";
val revcons = get_axiom prolog_thy "revcons";

goal prolog_thy
   "append(Cons(a,Cons(b,Cons(c,Nil))), Cons(d,Cons(e,Nil)), ?x)";
by (resolve_tac [appnil,appcons] 1);
by (resolve_tac [appnil,appcons] 1);
by (resolve_tac [appnil,appcons] 1);
by (resolve_tac [appnil,appcons] 1);
prth (uresult());

goal prolog_thy
  "append(?x, Cons(c,Cons(d,Nil)), Cons(a,Cons(b,Cons(c,Cons(d,Nil)))))";
by (REPEAT (resolve_tac [appnil,appcons] 1));
uresult();


goal prolog_thy "append(?x, ?y, Cons(a,Cons(b,Cons(c,Cons(d,Nil)))))";
by (REPEAT (resolve_tac [appnil,appcons] 1));
back();
back();
back();
back();
uresult();


goal prolog_thy "reverse(Cons(a,Cons(b,Cons(c,Cons(d,Nil)))), ?x)";
val rules = [appnil,appcons,revnil,revcons];
by (REPEAT (resolve_tac rules 1));

goal prolog_thy "reverse(?x, Cons(a,Cons(b,Cons(c,Nil))))";
by (REPEAT (resolve_tac rules 1));
back();
back();
(*does not solve it directly!*)
choplev 0;
by (DEPTH_FIRST (has_fewer_prems 1) (resolve_tac rules 1));
uresult();


val prolog_tac = DEPTH_FIRST (has_fewer_prems 1) (resolve_tac rules 1);

goal prolog_thy "reverse(Cons(a,Cons(?x,Cons(c,Cons(?y,Nil)))), \
\                        Cons(d,Cons(?z,Cons(b,?u))))";
by prolog_tac;

writeln"Reached end of file.";
