(*  Title: 	FOL/ex/nat
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Examples of simplification and induction on the natural numbers
*)

local open Syntax;

val mixfix =
[Delimfix("0", "nat", "0"),
 Infixr("+", "[nat,nat] => nat", 90),
 Infixr("<=", "[nat,nat] => o", 70),
 Infixr("<", "[nat,nat] => o", 70)
];

val sext = Sext{mixfix=mixfix, parse_translation=[], print_translation=[]};

val const_decs = [(["succ","pred"], "nat => nat")];

in

val nat_thy = extend_theory cla_thy "Nat"
	([], [], [(["nat"],([],"term"))], const_decs, Some(sext))
[
 ("pred_0", "pred(0) = 0"),
 ("pred_succ", "pred(succ(m)) = m"),

 ("plus_0", "0+n = n"),
 ("plus_succ", "succ(m)+n = succ(m+n)"),

 ("nat_distinct1", "~ 0=succ(n)"),
 ("nat_distinct2", "~ succ(m)=0"),
 ("succ_inject", "succ(m)=succ(n) <-> m=n"),

 ("leq_0", "0 <= n"),
 ("leq_succ_succ", "succ(m)<=succ(n) <-> m<=n"),
 ("leq_succ_0", "~ succ(m) <= 0"),

 ("lt_0_succ", "0 < succ(n)"),
 ("lt_succ_succ", "succ(m)<succ(n) <-> m<n"),
 ("lt_0", "~ m < 0"),

 ("nat_ind", "[| P(0); ALL n. P(n)-->P(succ(n)) |] ==> All(P)")
];
end;

local val ax = get_axiom nat_thy
in
val pred_0 = ax"pred_0";
val pred_succ = ax"pred_succ";
val plus_0 = ax"plus_0";
val plus_succ = ax"plus_succ";
val nat_distinct1 = ax"nat_distinct1";
val nat_distinct2 = ax"nat_distinct2";
val succ_inject = ax"succ_inject";
val leq_0 = ax"leq_0";
val leq_succ_succ = ax"leq_succ_succ";
val leq_succ_0 = ax"leq_succ_0";
val lt_0_succ = ax"lt_0_succ";
val lt_succ_succ = ax"lt_succ_succ";
val lt_0 = ax"lt_0";
val nat_ind = ax"nat_ind";
end;

val nat_cong_thms = mk_congs nat_thy ["succ", "pred", "op +", "op <", "op <="];

val nat_rew_thms = [pred_0, pred_succ, plus_0, plus_succ, 
		    nat_distinct1, nat_distinct2, succ_inject,
		    leq_0,leq_succ_succ,leq_succ_0, 
		    lt_0_succ,lt_succ_succ,lt_0];

val nat_ss = FOL_ss addcongs nat_cong_thms addrews nat_rew_thms;

val prems = goal nat_thy 
    "[| P(0);  !!x. P(succ(x)) |] ==> All(P)";
br nat_ind 1;
by (REPEAT (resolve_tac (prems@[allI,impI]) 1));
val nat_exh = result();

goal nat_thy "~ n=succ(n)";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "~ succ(n)=n";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "~ succ(succ(n))=n";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "~ n=succ(succ(n))";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "m+0 = m";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "m" 1);
val plus_0_right = result();

goal nat_thy "m+succ(n) = succ(m+n)";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "m" 1);
val plus_succ_right = result();

goal nat_thy "~n=0 --> m+pred(n) = pred(m+n)";
by (IND_TAC nat_ind (SIMP_TAC (nat_ss addrews [plus_succ_right])) "n" 1);
result();

goal nat_thy "~n=0 --> succ(pred(n))=n";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "m+n=0 <-> m=0 & n=0";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "m" 1);
result();

goal nat_thy "m <= n --> m <= succ(n)";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "m" 1);
br (impI RS allI) 1;
by (ALL_IND_TAC nat_ind (SIMP_TAC nat_ss) 1);
by (fast_tac FOL_cs 1);
val le_imp_le_succ = result() RS mp;

goal nat_thy "n<succ(n)";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "~ n<n";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
result();

goal nat_thy "m < n --> m < succ(n)";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "m" 1);
br (impI RS allI) 1;
by (ALL_IND_TAC nat_ind (SIMP_TAC nat_ss) 1);
by (fast_tac FOL_cs 1);
result();

goal nat_thy "m <= n --> m <= n+k";
by (IND_TAC nat_ind 
    (SIMP_TAC (nat_ss addrews [plus_0_right, plus_succ_right, le_imp_le_succ]))
     "k" 1);
val le_plus = result();

goal nat_thy "succ(m) <= n --> m <= n";
by (res_inst_tac [("x","n")]spec 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC (nat_ss addrews [le_imp_le_succ])) 1);
val succ_le = result();

goal nat_thy "~m<n <-> n<=m";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "n" 1);
br (impI RS allI) 1;
by (ALL_IND_TAC nat_ind (ASM_SIMP_TAC nat_ss) 1);
val not_less = result();

goal nat_thy "n<=m --> ~m<n";
by (SIMP_TAC (nat_ss addrews [not_less]) 1);
val le_imp_not_less = result();

goal nat_thy "m<n --> ~n<=m";
by (cut_facts_tac [not_less] 1 THEN fast_tac FOL_cs 1);
val not_le = result();

goal nat_thy "m+k<=n --> m<=n";
by (IND_TAC nat_ind (K all_tac) "k" 1);
by (SIMP_TAC (nat_ss addrews [plus_0_right]) 1);
br (impI RS allI) 1;
by (SIMP_TAC (nat_ss addrews [plus_succ_right]) 1);
by (REPEAT (resolve_tac [allI,impI] 1));
by (cut_facts_tac [succ_le] 1);
by (fast_tac FOL_cs 1);
val plus_le = result();

val prems = goal nat_thy "[| ~m=0;  m <= n |] ==> ~n=0";
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [rev_mp] 1));
by (IND_TAC nat_exh (SIMP_TAC nat_ss) "m" 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
val not0 = result();

goal nat_thy "a<=a' & b<=b' --> a+b<=a'+b'";
by (IND_TAC nat_ind (SIMP_CASE_TAC 
		     (nat_ss addrews [plus_0_right,le_plus])) "b" 1);
by (resolve_tac [impI RS allI] 1);
by (resolve_tac [allI RS allI] 1);
by (ALL_IND_TAC nat_exh (ASM_SIMP_TAC (nat_ss addrews [plus_succ_right])) 1);
val plus_le_plus = result();

goal nat_thy "i<=j --> j<=k --> i<=k";
by (IND_TAC nat_ind (K all_tac) "i" 1);
by (SIMP_TAC nat_ss 1);
by (resolve_tac [impI RS allI] 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (fast_tac FOL_cs 1);
val le_trans = result();

goal nat_thy "i < j --> j <=k --> i < k";
by (IND_TAC nat_ind (K all_tac) "j" 1);
by (SIMP_TAC nat_ss 1);
by (resolve_tac [impI RS allI] 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (fast_tac FOL_cs 1);
val less_le_trans = result();

goal nat_thy "succ(i) <= j <-> i < j";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "j" 1);
by (resolve_tac [impI RS allI] 1);
by (ALL_IND_TAC nat_exh (ASM_SIMP_TAC nat_ss) 1);
val succ_le = result();

goal nat_thy "i<succ(j) <-> i=j | i<j";
by (IND_TAC nat_ind (SIMP_TAC nat_ss) "j" 1);
by (ALL_IND_TAC nat_exh (SIMP_TAC nat_ss) 1);
by (resolve_tac [impI RS allI] 1);
by (ALL_IND_TAC nat_exh (ASM_SIMP_TAC nat_ss) 1);
val less_succ = result();

