(*  Title: 	FOL/ex/if
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

First-Order Logic: the 'if' example
*)

writeln"File FOL/ex/if.";

val if_thy = 
  extend_theory cla_thy "if"
    ([], [], [],
    [ (["if"], "[o,o,o]=>o") ],
    None)
    [ ("if_def", "if(P,Q,R) == P&Q | ~P & R") ];

val if_def = get_axiom if_thy "if_def";

val prems = goalw if_thy [if_def] "[| P ==> Q; ~P ==> R |] ==> if(P,Q,R)";
by (Classical.fast_tac (FOL_cs addIs prems) 1);
val ifI = result();

val major::prems = goalw if_thy [if_def]
   "[| if(P,Q,R);  [| P; Q |] ==> S; [| ~P; R |] ==> S |] ==> S";
by (cut_facts_tac [major] 1);
by (Classical.fast_tac (FOL_cs addIs prems) 1);
val ifE = result();

val if_cs = FOL_cs addSIs [ifI] addSEs[ifE];

goal if_thy "if(P, if(Q,A,B), if(Q,C,D)) <-> if(Q, if(P,A,C), if(P,B,D))";
by (resolve_tac [iffI] 1);
by (eresolve_tac [ifE] 1);
by (eresolve_tac [ifE] 1);
by (resolve_tac [ifI] 1);
by (resolve_tac [ifI] 1);

choplev 0;
by (Classical.fast_tac if_cs 1);
val if_commute = result();


goal if_thy "if(if(P,Q,R), A, B) <-> if(P, if(Q,A,B), if(R,A,B))";
by (Classical.fast_tac if_cs 1);
val nested_ifs = result();

choplev 0;
by (rewrite_goals_tac [if_def]);
by (Classical.fast_tac FOL_cs 1);
result();


(*An invalid formula.  High-level rules permit a simpler diagnosis*)
goal if_thy "if(if(P,Q,R), A, B) <-> if(P, if(Q,A,B), if(R,B,A))";
by (REPEAT (Classical.step_tac if_cs 1));

choplev 0;
by (rewrite_goals_tac [if_def]);
by (REPEAT (Classical.step_tac FOL_cs 1));


writeln"Reached end of file.";
