(*  Title: 	CUBE/ruleshell
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

Contexts are handled by turning them into Isabelle premisses while checking
that the types are well-formed. Note that this permits two kinds of
nonsensical assumptions:
1. Multiple assumptions for the same variable: a:T1 a:T2 ...
2. Assumptions involving proper terms: (a^b):T
Both are viewed as context-condition violations.

The beta-conversion rule is too general: it should only apply to a type A in
an assertion a:A

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature CUBE_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val s_b: thm
  val strip_s: thm
  val strip_b: thm
  val app: thm
  val pi_ss: thm
  val lam_ss: thm
  val beta: thm
  end;


functor CUBE_RuleFun (CUBE_Syntax: CUBE_SYNTAX) : CUBE_RULE = 
struct

val thy = extend_theory pure_thy "CUBE"
([],[],
 [(["term"], ([],"logic")),
  (["context","necontext","typing"], ([],"any"))],
 CUBE_Syntax.const_decs,
 Some(CUBE_Syntax.sext))
[
  ("s_b",    "*: []"  ),

  ("strip_s", "[| A:*;  a:A ==> G |- x:X |] ==> a:A G |- x:X"),
  ("strip_b", "[| A:[]; a:A ==> G |- x:X |] ==> a:A G |- x:X"),

  ("app",    "[| F:Prod(A,B); C:A |] ==> F^C: B(C)"),

  ("pi_ss",  "[| A:*; !!x. x:A ==> B(x):* |] ==> Prod(A,B):*"),

  ("lam_ss", "[| A:*; !!x. x:A ==> f(x):B(x); !!x. x:A ==> B(x):* |] \
\	==> Abs(A,f) : Prod(A,B)"),

  ("beta", "Abs(A,f)^a == f(a)")
];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val s_b = ax"s_b";
val strip_s = ax"strip_s";
val strip_b = ax"strip_b";
val app = ax"app";
val pi_ss = ax"pi_ss";
val lam_ss = ax"lam_ss";
val beta = ax"beta";
end;
