(*  Title: 	CTT/syntax
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Constructive Type Theory syntax*)

signature CTT_SYNTAX =
  sig
  val const_decs: (string list * string) list
  val sext: Syntax.sext
  end;

functor CTT_SyntaxFun () : CTT_SYNTAX = 
struct
local open Syntax
in

(** Translation of 'dependent' type operators **)

fun dependent_tr q [Free(id,T),A,B] = Const(q,dummyT) $ A $ absfree(id,T,B);

(*Translation of * and --> to Sum and Prod*)
fun ndependent_tr q [A,B] = 
    Const(q,dummyT) $ A $ Abs("uu", dummyT, incr_boundvars 1 B);

(*Is there a dependence or not? Use quantifier q if so; use r if not. *)
fun dependent_tr' (q,r) [A, Abs(id,T,B)] =
    if 0 mem (loose_bnos B) 
    then 
      let val (id',B') = variant_abs(id,T,B)
      in Const(q,dummyT) $ Free(id',T) $ A $ B' end
    else Const(r,dummyT) $ A $ B;

val mixfix =
[   (*Judgements*)
  Mixfix("(_ type)", "t => prop", "Type", [10], 5),
  Mixfix("(3_ =/ _)", "[t,t]=>prop", "Eqtype", [10,10],5),
  Mixfix("(_ /: _)", "[i, t]=>prop", "Elem", [10,10], 5),
  Mixfix("(3_ =/ _ :/ _)", "[i,i,t]=>prop", "Eqelem",
			   [10,10,10],5),
  Delimfix("Reduce'(_,_')", "[i,i]=>prop", "Reduce"),
    (*Types*)
  Mixfix("(3PROD _:_./ _)", "[ID,t,t]=>t", "@PROD", [], 10),
  Mixfix("(3SUM _:_./ _)",  "[ID,t,t]=>t", "@SUM", [], 10),
  Infixr("+", "[t,t]=>t", 30),
  (*Invisible infixes!*)
  Mixfix("(_ */ _)", "[t,t]=>t", "@*", [36,35], 35),
  Mixfix("(_ -->/ _)", "[t,t]=>t", "@-->", [26,25], 25),
    (*Functions*)
  Binder("lam ", "i", "i", "i", "lambda", 0, 10),
  Infixl("`", "[i,i]=>i", 55),
    (*Natural numbers*)
  Delimfix("0", "i", "0"),
    (*Pairing*)
  Delimfix("(1<_,/_>)", "[i,i]=>i", "pair") ];

val sext = 
Sext{
  mixfix=mixfix,
  parse_translation=
    [("@PROD", dependent_tr "Prod"),
     ("@SUM",  dependent_tr "Sum"),
     ("@-->", ndependent_tr "Prod"),
     ("@*",  ndependent_tr "Sum") ],
  print_translation=
    [("Prod", dependent_tr' ("@PROD","@-->")),
     ("Sum",  dependent_tr' ("@SUM","@*")) ]};

val const_decs =
[(*Types*)
 (["F","T"],	"t"),	(*F is empty, T contains one element*)
 (["contr"],	"i=>i" ),
 (["tt"],	"i"),
    (*Natural numbers*)
 (["N"],	"t"),
 (["succ"],	"i=>i"),
 (["rec"],	"[i, i, [i,i]=>i] => i"),
    (*Unions*)
 (["inl","inr"],"[i]=>i"),
 (["when"],	"[i, i=>i, i=>i]=>i"),
    (*General Sum and Binary Product*)
 (["Sum"],	"[t, i=>t]=>t"),
 (["fst","snd"],"i=>i"),
 (["split"],	"[i, [i,i]=>i] =>i"),
    (*General Product and Function Space*)
 (["Prod"],	"[t, i=>t]=>t"),
    (*Equality type*)
 (["Eq"],	"[t,i,i]=>t" ),
 (["eq"],	"i" ) ];

end;
end;
