(*  Title: 	pure
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Super module containing all modules of pure Isabelle
*)

signature PURE =
sig
  structure Sign: SIGN
  structure Sequence: SEQUENCE
  structure Envir: ENVIR
  structure Unify: UNIFY
  structure Logic: LOGIC
  structure Stringtree: STRINGTREE
  (*Signature THM*)
  type theory
  type thm
  exception THM of string * int * thm list
  exception THEORY of string * theory list
  val abstract_rule: string -> Sign.cterm -> thm -> thm
  val asm_rl: thm
  val assume: Sign.cterm -> thm
  val assumption: thm * int -> thm Sequence.seq   
  val beta_conversion: Sign.cterm -> thm   
  val bicompose: thm * int -> bool * thm * int -> thm Sequence.seq   
  val biresolution: thm * int * (bool*thm)list -> thm Sequence.seq   
  val combination: thm -> thm -> thm   
  val concl_of: thm -> term   
  val cut_rl: thm
  val dest_state: thm * int -> (term*term)list * term list * term * term
  val env_instantiate: Envir.env -> thm -> thm
  val enrich_theory: theory -> string -> string list * (string list * typ)list * Sign.Syntax.syntax -> (string*string)list -> theory
  val eq_assumption: thm * int -> thm   
  val equal_props: thm -> thm -> thm   
  val extend_theory: theory -> string -> string list * (string list * typ)list -> (string*string)list -> theory
  val extensional: thm -> thm   
  val forall_elim: Sign.cterm -> thm -> thm
  val forall_intr: Sign.cterm -> thm -> thm
  val get_axiom: theory -> string -> thm
  val implies_elim: thm -> thm -> thm
  val implies_intr: Sign.cterm -> thm -> thm
  val implies_intr_hyps: thm -> thm
  val instantiate: (Sign.cterm*Sign.cterm) list -> thm -> thm
  val kind_of_theory: theory -> string   
  val lift_rule: (thm * int) -> thm -> thm
  val merge_theories: theory * theory -> theory   
  val prems_of: thm -> term list
  val pure_thy: theory
  val reflexive: Sign.cterm -> thm 
  val rep_thm: thm ->  {prop: term, hyps: term list, maxidx: int, sign: Sign.sg}
  val resolution: thm * int * thm list -> thm Sequence.seq   
  val sign_of: theory -> Sign.sg   
  val symmetric: thm -> thm   
  val tpairs_of: thm -> (term*term)list
  val transitive: thm -> thm -> thm   
  val trivial: Sign.cterm -> thm
  val unify_instantiate: (term*term) list -> thm -> thm Sequence.seq
  (*Signature TACTICAL*)
    datatype tactic = Tactic of thm -> thm Sequence.seq
    val all_tac: tactic
    val ALLGOALS: (int -> tactic) -> tactic   
    val APPEND: tactic * tactic -> tactic
    val APPEND': ('a -> tactic) * ('a -> tactic) -> 'a -> tactic
    val assume_ax: theory -> string -> thm
    val BEST_FIRST: (thm -> bool) * (thm -> int) -> tactic -> tactic
    val BREADTH_FIRST: (thm -> bool) -> tactic -> tactic
    val COND: (thm -> bool) -> tactic -> tactic -> tactic   
    val DEPTH_FIRST: (thm -> bool) -> tactic -> tactic
    val DEPTH_SOLVE_1: tactic -> tactic
    val DETERM: tactic -> tactic
    val EVERY: tactic list -> tactic   
    val FIRST: tactic list -> tactic   
    val FIRSTGOAL: (int -> tactic) -> tactic
    val forall_intr_list: Sign.cterm list -> thm -> thm
    val forall_intr_frees: thm -> thm
    val forall_elim_var: int -> thm -> thm
    val forall_elim_vars: int -> thm -> thm
    val has_fewer_prems: int -> thm -> bool   
    val implies_intr_list: Sign.cterm list -> thm -> thm
    val MAP_EVERY: ('a -> tactic) -> 'a list -> tactic
    val MAP_FIRST: ('a -> tactic) -> 'a list -> tactic
    val no_tac: tactic
    val ORELSE: tactic * tactic -> tactic
    val ORELSE': ('a -> tactic) * ('a -> tactic) -> 'a -> tactic
    val read_instantiate: theory -> (string*string*typ)list -> thm -> thm
    val REPEAT1: tactic -> tactic
    val REPEAT: tactic -> tactic
    val REPEAT_FIRST: (int -> tactic) -> tactic
    val REPEAT_SOME: (int -> tactic) -> tactic
    val RES: thm * thm -> thm
    val RESN: thm * (int * thm list) -> thm
    val reslist: thm list * int * thm -> thm list
    val RS: thm * thm -> thm
    val RSN: thm list * (int * thm) -> thm
    val SELECT_GOAL: tactic -> int -> tactic
    val SOMEGOAL: (int -> tactic) -> tactic   
    val standard: thm -> thm
    val STATE: (thm -> tactic) -> tactic
    val SUBGOAL: ((term*int) -> tactic) -> int -> tactic
    val tapply: tactic * thm -> thm Sequence.seq
    val THEN: tactic * tactic -> tactic
    val THEN': ('a -> tactic) * ('a -> tactic) -> 'a -> tactic
    val TRY: tactic -> tactic
    val TRYALL: (int -> tactic) -> tactic   
    val zero_var_indexes: thm -> thm
  (*Signature TACTIC*)
    val ares_tac: thm list -> int -> tactic   
    val assume_tac: int -> tactic   
    val biresolve_tac: (bool*thm)list -> int -> tactic
    val compat_resolve_tac: thm list -> int -> int -> tactic   
    val compat_thms: 'a Stringtree.tree * term -> 'a list   
    val compose_inst_tac: (string*string*typ)list -> (bool*thm*int) -> int -> tactic   
    val compose_tac: (bool * thm * int) -> int -> tactic 
    val cut_facts_tac: thm list -> int -> tactic
    val eq_assume_tac: int -> tactic   
    val eresolve_tac: thm list -> int -> tactic
    val eres_inst_tac: (string*string*typ)list -> thm -> int -> tactic   
    val filter_thms: (term*term->bool) -> int*term*thm list -> thm list
    val filt_resolve_tac: thm list -> int -> int -> tactic
    val forwards_tac: thm -> int -> tactic   
    val head_string: term -> string list
    val insert_thm: thm * thm Stringtree.tree -> thm Stringtree.tree
    val lessb: (bool * thm) * (bool * thm) -> bool
    val lift_inst_rule: thm * int * (string*string*typ)list * thm -> thm
    val lift_inst_tac: (string*string*typ)list -> thm -> int -> tactic   
    val metacut_tac: thm -> int -> tactic   
    val PRIMITIVE: (thm -> thm) -> tactic  
    val resolve_tac: thm list -> int -> tactic
    val res_inst_tac: (string*string*typ)list -> thm -> int -> tactic   
    val smash_all_ff_tac: tactic
    val subgoals_of_brl: bool * thm -> int
    val subgoal_tac: string -> int -> tactic
    val trace_tac: int -> tactic
  (*Signature GOALS*)
    type gstack
    val back: unit -> unit
    val by: tactic -> unit
    val byev: tactic list -> unit
    val chop: unit -> unit
    val choplev: int -> unit
    val compat_goal: thm list -> int -> thm list
    val curr_prems: thm list ref
    val filter_goal: (term*term->bool) -> thm list -> int -> thm list
    val getgoal: int -> term
    val getstate: unit -> gstack
    val goal: theory -> string -> thm list
    val goals_limit: int ref
    val pr: unit -> unit
    val print_goals: int -> thm -> unit
    val print_thm: thm -> unit
    val prlev: int -> unit
    val prth: thm -> unit
    val prths: thm list -> unit
    val prove_goal: theory -> string -> (thm list -> tactic list) -> thm
    val result: unit -> thm  
    val uresult: unit -> thm  
    val setstate: gstack -> unit
    val topthm: unit -> thm
    val undo: unit -> unit
  (*Signature CONV*)
    type conv
    exception CONV
    val all_conv: conv
    val beta_conv: conv
    val changed_conv: conv -> conv
    val conv_cterm: conv -> Sign.cterm -> thm
    val depth_conv: conv -> conv
    val every_conv: conv list -> conv
    val fconv_rule: conv -> thm -> thm
    val first_conv: conv list -> conv
    val fold_tac: thm list -> tactic
    val goals_conv: conv -> conv
    val immed_conv: thm list -> conv
    val no_conv: conv
    val orelsec: conv*conv->conv
    val part_tmatch: (term -> term) -> thm -> {sign: Sign.sg, nextfree: int} -> term -> thm
    val redepth_conv: conv -> conv
    val repeatc: conv -> conv
    val rewrite_conv: thm->conv
    val rewrite_cterm: thm list -> Sign.cterm -> thm
    val rewrite_goals_rule: thm list -> thm -> thm
    val rewrite_goal_tac: thm list -> int -> tactic
    val rewrite_goals_tac: thm list -> tactic
    val rewrite_rule: thm list -> thm -> thm
    val rewrite_tac: thm list -> tactic
    val sub_conv: conv -> conv
    val thenc: conv*conv->conv
    val top_depth_conv: conv -> conv
    val top_immed_conv: thm list -> conv
    val try_conv: conv -> conv
end;

functor PureFun (): PURE =
struct
  structure Sign = SignFun(Syntax); 
  structure Sequence = SequenceFun();
  structure Envir = EnvirFun();
  structure Unify = UnifyFun(structure Envir=Envir and Sequence=Sequence
                             and Pretty=Pretty);
  structure Logic = LogicFun(Unify);
  structure Thm = ThmFun(structure Logic=Logic and Unify=Unify and Sign=Sign); 
  structure Stringtree = StringtreeFun();
  structure Tactical = TacticalFun(structure Logic=Logic and Thm=Thm);
  structure Tactic = TacticFun(structure Logic=Logic and Tactical=Tactical
                               and Stringtree=Stringtree);
  structure Conv = ConvFun(structure Logic=Logic and Tactic=Tactic);
  structure Goals = GoalsFun(structure Logic=Logic and Tactic=Tactic
                             and Pretty=Pretty);
  open Thm Tactical Tactic Goals Conv;
end;
