(*  Title: 	FOL/ex/cla
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical First-Order Logic

Single-step commands:
by (onestep_tac 1);
by (step_tac [] 1);
by (fast_tac [] 1);
by (biresolve_tac safe_brls 1);
by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
*)

writeln"File FOL/ex/cla.";

goal cla_thy "(P --> Q | R) --> (P-->Q) | (P-->R)";
by (fast_tac [] 1);
result();

(*If and only if*)

goal cla_thy "(P<->Q) <-> (Q<->P)";
by (fast_tac [] 1);
result();

goal cla_thy "~ (P <-> ~P)";
by (fast_tac [] 1);
result();


(*Sample problems from 
  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.
*)

writeln"Pelletier's examples";
(*1*)
goal cla_thy "(P-->Q)  <->  (~Q --> ~P)";
by (fast_tac [] 1);
result();

(*2*)
goal cla_thy "~ ~ P  <->  P";
by (fast_tac [] 1);
result();

(*3*)
goal cla_thy "~(P-->Q) --> (Q-->P)";
by (fast_tac [] 1);
result();

(*4*)
goal cla_thy "(~P-->Q)  <->  (~Q --> P)";
by (fast_tac [] 1);
result();

(*5*)
goal cla_thy "((P|Q)-->(P|R)) --> (P|(Q-->R))";
by (fast_tac [] 1);
result();

(*6*)
goal cla_thy "P | ~ P";
by (fast_tac [] 1);
result();

(*7*)
goal cla_thy "P | ~ ~ ~ P";
by (fast_tac [] 1);
result();

(*8.  Peirce's law*)
goal cla_thy "((P-->Q) --> P)  -->  P";
by (fast_tac [] 1);
result();

(*9*)
goal cla_thy "((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q)";
by (fast_tac [] 1);
result();

(*10*)
goal cla_thy "(Q-->R) & (R-->P&Q) & (P-->Q|R) --> (P<->Q)";
by (fast_tac [] 1);
result();

(*11.  Proved in each direction (incorrectly, says Pelletier!!)  *)
goal cla_thy "P<->P";
by (fast_tac [] 1);
result();

(*12.  "Dijkstra's law"*)
goal cla_thy "((P <-> Q) <-> R)  -->  (P <-> (Q <-> R))";
by (fast_tac [] 1);
result();

(*13.  Distributive law*)
goal cla_thy "P | (Q & R)  <-> (P | Q) & (P | R)";
by (fast_tac [] 1);
result();

(*14*)
goal cla_thy "(P <-> Q) <-> ((Q | ~P) & (~Q|P))";
by (fast_tac [] 1);
result();

(*15*)
goal cla_thy "(P --> Q) <-> (~P | Q)";
by (fast_tac [] 1);
result();

(*16*)
goal cla_thy "(P-->Q) | (Q-->P)";
by (fast_tac [] 1);
result();

(*17*)
goal cla_thy "((P & (Q-->R))-->S)  <->  ((~P | Q | S) & (~P | ~R | S))";
by (fast_tac [] 1);
result();

writeln"Classical Logic: examples with quantifiers.";

goal cla_thy "(ALL x. P(x) & Q(x)) <-> (ALL x. P(x))  &  (ALL x. Q(x))";
by (fast_tac [] 1);
result(); 



goal cla_thy "(EX x. P-->Q(x))  <->  (P --> (EX x.Q(x)))";
by (fast_tac [] 1);
result(); 


goal cla_thy "(EX x.P(x)-->Q)  <->  (ALL x.P(x)) --> Q";
by (fast_tac [] 1);
result(); 


goal cla_thy "(ALL x.P(x)) | Q  <->  (ALL x. P(x) | Q)";
by (fast_tac [] 1);
result(); 


writeln"Testing the complete tactic";

(*Not provable by pc_tac: needs multiple instantiation of ALL.
  Could be proved trivially by a PROLOG interpreter*)
goal cla_thy "(ALL x. P(x)-->P(f(x)))  &  P(d)-->P(f(f(f(d))))";
by (comp_tac []);
result();


(*Not provable by pc_tac: needs double instantiation of EXISTS*)
goal cla_thy "EX x. P(x) --> P(a) & P(b)";
by (comp_tac []);
result();

goal cla_thy "EX z. P(z) --> (ALL x. P(x))";
by (comp_tac []);
result();


writeln"Hard examples with quantifiers";

writeln"Problem 18. ";
goal cla_thy "EX y. ALL x. P(y)-->P(x)";
by (comp_tac []);
result(); 



writeln"Problem 19. ";
goal cla_thy "EX x. ALL y z. (P(y)-->Q(z)) --> (P(x)-->Q(x))";
by (comp_tac []);
(* or faster: (resolve_tac [exists_cintr] 1 THEN pc_tac [] 1) *)
result();


writeln"Problem 20. ";
goal cla_thy "(ALL x y. EX z. ALL w. (P(x)&Q(y)-->R(z)&S(w)))     \
\   --> (EX x y. P(x) & Q(y)) --> (EX z. R(z))";
by (fast_tac [] 1); 
result();



writeln"Problem 21.  ";
goal cla_thy "(EX x. P-->Q(x)) & (EX x. Q(x)-->P) --> (EX x. P<->Q(x))";
by (comp_tac []); 
result();


writeln"Problem 22";
goal cla_thy "(ALL x. P <-> Q(x))  -->  (P <-> (ALL x. Q(x)))";
by (fast_tac [] 1); 
result();


writeln"Problem 23";
goal cla_thy "(ALL x. P | Q(x))  <->  (P | (ALL x. Q(x)))";
by (best_tac []);  
result();


writeln"Problem 24";
goal cla_thy "~(EX x. S(x)&Q(x)) & (ALL x. P(x) --> Q(x)|R(x)) &  \
\    ~(EX x.P(x)) --> (EX x.Q(x)) & (ALL x. Q(x)|R(x) --> S(x))  \
\   --> (EX x. P(x)&R(x))";
by (fast_tac [] 1); 
result();


writeln"Problem 25";
goal cla_thy "(EX x. P(x)) &  \
\       (ALL x. L(x) --> ~ (M(x) & R(x))) &  \
\       (ALL x. P(x) --> (M(x) & L(x))) &   \
\       ((ALL x. P(x)-->Q(x)) | (EX x. P(x)&R(x)))  \
\   --> (EX x. Q(x)&P(x))";
by (best_tac []); 
result();


writeln"Problem 27";
goal cla_thy "(EX x. P(x) & ~Q(x)) &   \
\       (ALL x. P(x) --> R(x)) &   \
\       (ALL x. M(x) & L(x) --> P(x)) &   \
\       ((EX x. R(x) & ~ Q(x)) --> (ALL x. L(x) --> ~ R(x)))  \
\   --> (ALL x. M(x) --> ~L(x))";
by (best_tac []); 
result();


writeln"Problem 28.  AMENDED";
goal cla_thy "(ALL x. P(x) --> (ALL x. Q(x))) &   \
\       ((ALL x. Q(x)|R(x)) --> (EX x. Q(x)&S(x))) &  \
\       ((EX x.S(x)) --> (ALL x. L(x) --> M(x)))  \
\   --> (ALL x. P(x) & L(x) --> M(x))";
by (fast_tac [] 1);  
result();


writeln"Problem 29.  Essentially the same as Principia Mathematica *11.71";
goal cla_thy "(EX x. P(x)) & (EX y. Q(y))  \
\   --> ((ALL x. P(x)-->R(x)) & (ALL y. Q(y)-->S(y))   <->     \
\       (ALL x y. P(x) & Q(y) --> R(x) & S(y)))";
by (fast_tac [] 1); 
result();


writeln"Problem 30";
goal cla_thy "(ALL x. P(x) | Q(x) --> ~ R(x)) & \
\       (ALL x. (Q(x) --> ~ S(x)) --> P(x) & R(x))  \
\   --> (ALL x. S(x))";
by (fast_tac [] 1);  
result();


writeln"Problem 31.  ";
goal cla_thy "~(EX x.P(x) & (Q(x) | R(x))) & \
\       (EX x. L(x) & P(x)) & \
\       (ALL x. ~ R(x) --> M(x))  \
\   --> (EX x. L(x) & M(x))";
by (fast_tac [] 1);
result();


writeln"Problem 32.  ";
goal cla_thy "(ALL x. P(x) & (Q(x)|R(x))-->S(x)) & \
\       (ALL x. S(x) & R(x) --> L(x)) & \
\       (ALL x. M(x) --> R(x))  \
\   --> (ALL x. P(x) & M(x) --> L(x))";
by (best_tac []);
result();


writeln"Problem 33";
goal cla_thy "(ALL x. P(a) & (P(x)-->P(b))-->P(c))  <->    \
\    (ALL x. (~P(a) | P(x) | P(c)) & (~P(a) | ~P(b) | P(c)))";
by (best_tac []);
result();


writeln"Problem 35.  ";
goal cla_thy "EX x y. P(x,y) -->  (ALL u v. P(u,v))";
by (comp_tac []);
result();


writeln"Problem 36.  ";
goal cla_thy "(ALL x. EX y. J(x,y)) & \
\       (ALL x. EX y. G(x,y)) & \
\       (ALL x y. J(x,y) | G(x,y) -->	\
\       (ALL z. J(y,z) | G(y,z) --> H(x,z)))   \
\   --> (ALL x. EX y. H(x,y))";
by (fast_tac [] 1);
(***proved???***)

writeln"Problem 37";
goal cla_thy "(ALL z. EX w. ALL x. EX y. \
\          (P(x,z)-->P(y,w)) & P(y,z) & (P(y,w) --> (EX u.Q(u,w)))) & \
\       (ALL x z. ~P(x,z) --> (EX y. Q(y,z))) & \
\       ((EX x y. Q(x,y)) --> (ALL x. R(x,x)))  \
\   --> (ALL x. EX y. R(x,y))";
by (fast_tac [] 1);
result();


writeln"Problem 39";
goal cla_thy "~ (EX x. ALL y. J(x,y) <-> ~J(y,y))";
by (fast_tac [] 1);
result();


writeln"Problem 40.  AMENDED";
goal cla_thy "(EX y. ALL x. J(y,x) <-> ~J(x,x))  \
\       -->  ~ (ALL x. EX y. ALL z. J(z,y) <-> ~ J(z,x))";
by (fast_tac [] 1);
result();



writeln"Reached end of file.";

(*24 August 1988: loaded in 688 seconds*)
(*10 September 1988: loaded in 443 seconds*)
