fun filter_out f l = filter (fn e => not (f e)) l;

(*removing an element from a list without duplicates*)
infix rem;
fun x rem (y::l) = if x=y then l else y::(x rem l) |
    x rem [] = [];

(* pref n l yields the first n elements of l if n <= length l,
   l otherwise *)
fun pref 0 l = [] |
    pref _ [] = [] |
    pref k (e::l) = e::(pref (k-1) l);

fun Partition (eq:'a * 'a -> bool) (l: 'a list) : 'a list list =
    let fun part [] = [] |
            part (x::l) = let val (xl,nxl) = partition (apl(x,eq)) l
                          in (x::xl)::(part nxl) end
    in part l end;

fun product l1 l2  = flat(map (fn x => map (fn y => (x,y)) l2) l1);

fun find_first test l =
    let fun find [] = raise LIST "find_first" |
            find (e::l) = if test e then e else find l
    in find l end;

(* put in term! *)

fun strip_qnt_body qnt =
    let fun strip(tm as Const(c,_)$Abs(_,_,t)) = if c=qnt then strip t else tm
	  | strip t = t
    in strip end;

fun strip_qnt_vars qnt =
    let fun strip(Const(c,_)$Abs(a,T,t)) = if c=qnt then (a,T)::strip t else []
	  | strip t  =  [] : (string*typ) list
    in strip end;
