(*  Title: 	NJ/ex/quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Intuitionistic FOL: examples with quantifiers

This entire file can be loaded to test the NJ system.

Single-step commands:

by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
by (safe_tac 1);
by (pc_tac 1);
*)


writeln"Examples with quantifiers";

goal NJ_Rule.thy "[| (EXISTS y. ALL x. Q(x,y))  \
\                        -->  (ALL x. EXISTS y. Q(x,y)) |]";
by (resolve_tac [imp_intr] 1);
by (resolve_tac [all_intr] 1);
by (resolve_tac [exists_elim] 1 THEN assume_tac 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [all_elim] 1 THEN assume_tac 1);
by (assume_tac 1);
result();  



goal NJ_Rule.thy "[| (ALL x. P)  -->  P |]";
by (pc_tac 1);
result();  

goal NJ_Rule.thy "[| (ALL x.ALL y.P(x,y))  -->  (ALL y.ALL x.P(x,y)) |]";
by (pc_tac 1);
result();  


goal NJ_Rule.thy
  "[| (EXISTS x.EXISTS y.P(x,y)) --> (EXISTS y.EXISTS x.P(x,y)) |]";
by (pc_tac 1);
result();  


goal NJ_Rule.thy "[| (ALL x. P(x) & Q(x)) --> (ALL x.P(x)) & (ALL x.Q(x)) |]";
by (pc_tac 1);
result();  

goal NJ_Rule.thy "[| (ALL x.P(x)) & (ALL x.Q(x)) --> (ALL x. P(x) & Q(x)) |]";
by (pc_tac 1);
result();  


(*Converse is false*)
goal NJ_Rule.thy "[| (ALL x.P(x)) | (ALL x.Q(x)) --> (ALL x. P(x) | Q(x)) |]";
by (pc_tac 1);
result();  

goal NJ_Rule.thy "[| (ALL x. P-->Q(x))  <->  (P--> ALL x.Q(x)) |]";
by (pc_tac 1);
result();  


goal NJ_Rule.thy "[| (ALL x.P(x)-->Q)  <->  ((EXISTS x.P(x)) --> Q) |]";
by (pc_tac 1);
result();  


goal NJ_Rule.thy "[| (EXISTS x. P)  <->  P |]";
by (pc_tac 1);
result();  


writeln"Some harder ones";

goal NJ_Rule.thy
 "[| (EXISTS x. P(x) | Q(x)) <-> (EXISTS x.P(x)) | (EXISTS x.Q(x)) |]";
by (pc_tac 1);
result();  
(*6 secs*)

(*Converse is false*)
goal NJ_Rule.thy
   "[| (EXISTS x. P(x)&Q(x)) --> (EXISTS x.P(x))  &  (EXISTS x.Q(x)) |]";
by (pc_tac 1);
result();  


(*Converse is classical*)
goal NJ_Rule.thy "[| (EXISTS x. P --> Q(x)) --> (P --> EXISTS x. Q(x)) |]";
by (pc_tac 1);
result();  
(*2 secs*)


writeln"And more...";


(*Converse is classical;  even its double negation fails constructively*)
goal NJ_Rule.thy "[| (EXISTS x.P(x)-->Q)  -->  (ALL x.P(x)) --> Q |]";
by (pc_tac 1); 
(*2 secs*)
result();  


goal NJ_Rule.thy "[| ((ALL x.P(x))-->Q) --> ~ALL x. P(x) & ~Q |]";
by (pc_tac 1); 
(*6 secs*)
result();  

goal NJ_Rule.thy "[| ((ALL x. ~P(x))-->Q)  -->  ~ ALL x. ~ (P(x)|Q) |]";
by (pc_tac 1); 
(*10 secs*)
result();  


(*Converse is classical*)
goal NJ_Rule.thy "[| (ALL x.P(x)) | Q  -->  (ALL x. P(x) | Q) |]";
by (pc_tac 1); 
result();  



(*Basic test of quantifier reasoning*)
(*TRUE*)
goal NJ_Rule.thy "[| (EXISTS y. ALL x. Q(x,y))  \
\                        -->  (ALL x. EXISTS y. Q(x,y)) |]";
by (pc_tac 1);  
result();  


goal NJ_Rule.thy "[| (ALL x. Q(x))  -->  (EXISTS x. Q(x)) |]";
by (pc_tac 1);  
result();  


writeln"The following should fail, as they are false!";

(*FALSE*)
goal NJ_Rule.thy "[| (ALL x. EXISTS y. Q(x,y))  \
\            -->     (EXISTS y. ALL x. Q(x,y)) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
(*Check that subgoals remain: proof failed.*)
get_goal 1; 

(*FALSE*)
goal NJ_Rule.thy "[| (EXISTS x. Q(x))  -->  (ALL x. Q(x)) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 


goal NJ_Rule.thy "[| (ALL x.P(x)-->Q(x)) & (EXISTS x.P(x))--> EXISTS x.Q(x) |]";
by (pc_tac 1);  
result();  



(*An example of why exists_intr should be delayed as long as possible*)
goal NJ_Rule.thy "[| (P--> EXISTS x.Q(x)) & P--> EXISTS x.Q(x) |]";
by (pc_tac 1);  
result();  


(*The Var is called ?x so that it will have type exp (from its other uses)*)
goal NJ_Rule.thy
    "[| (ALL x. P(x)-->Q(f(x))) & (ALL x. Q(x)-->R(g(x))) & P(d) --> R(?x) |]";
by (pc_tac 1); 
(*Verify that no subgoals remain.*) 
uresult();  


writeln"The following are not constructively valid!";
(*The attempt to prove them terminates quickly!*)

goal NJ_Rule.thy "[| ((ALL x.P(x))-->Q) --> (EXISTS x.P(x)-->Q) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 

goal NJ_Rule.thy "[| (P-->EXISTS x.Q(x)) --> EXISTS x. P-->Q(x) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 

goal NJ_Rule.thy "[| (ALL x. P(x) | Q) --> ((ALL x.P(x)) | Q) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 

goal NJ_Rule.thy "[| (ALL x. ~ ~ P(x)) --> ~ ~ ALL x. P(x) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 


(*Classically but not intuitionistically valid
   Proved via a bug in previous versions*)
goal NJ_Rule.thy "[| EXISTS x. (Q(x) --> ALL x. Q(x)) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 


writeln"Some slow ones";


(*Principia Mathematica *11.53  *)
goal NJ_Rule.thy "[| (ALL x. ALL y. P(x) --> Q(y)) <-> \
\                    ((EXISTS x. P(x)) --> ALL y. Q(y)) |]";
by (pc_tac 1);
result();  
(*6 secs*)

(*Principia Mathematica *11.55  *)
goal NJ_Rule.thy "[| (EXISTS x. EXISTS y. P(x) & Q(x,y)) <-> \
\                    (EXISTS x. P(x) & EXISTS y. Q(x,y)) |]";
by (pc_tac 1);
result();  
(*9 secs*)

(*Principia Mathematica *11.61  *)
goal NJ_Rule.thy "[| (EXISTS y. ALL x. P(x) --> Q(x,y))    -->  \
\                    ALL x. P(x) --> EXISTS y. Q(x,y) |]";
by (pc_tac 1);
result();  
(*3 secs*)


(*Principia Mathematica *11.71   SLOW*)
goal NJ_Rule.thy "[| (EXISTS z. P(z)) & (EXISTS w. Q(w)) -->   \
\  ((ALL z. P(z) --> R(z)) & (ALL w. Q(w) --> S(w))   \
\        <-> (ALL z. ALL w. P(z) & Q(w) --> R(z) & S(w)))  |]";
by (pc_tac 1);
(*56 secs?  was 49 secs for LJ*)
result();


writeln"Examples from The Foundation of a Generic Theorem Prover";

val asms =
goal NJ_Rule.thy "[| ALL z. G(z) |] ==> [| ALL z. G(z)|H(z) |]";
by (resolve_tac [all_intr] 1);
by (resolve_tac [disj_intr1] 1);
by (resolve_tac [spec RESN (1,asms)] 1); 
  (*can use instead
    by (resolve_tac [spec] 1);  by (resolve_tac asms 1); *)
result();


goal NJ_Rule.thy "[| ALL x. EXISTS y. x=y |]";
by (resolve_tac [all_intr] 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [refl] 1);
result();


goal NJ_Rule.thy "[| EXISTS y. ALL x. x=y |]";
by (resolve_tac [exists_intr] 1);
by (resolve_tac [all_intr] 1);
by (resolve_tac [refl] 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1; 


(*Parallel lifting example. *)
goal NJ_Rule.thy "[| EXISTS u.ALL x.EXISTS v.ALL y.EXISTS w. P(u,x,v,y,w) |]";
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);


val asms =
goal NJ_Rule.thy "[| (EXISTS z.F(z)) & B |] ==> [| EXISTS z. F(z) & B |]";
by (resolve_tac [conj_elim] 1);
by (resolve_tac asms 1);
by (resolve_tac [exists_elim] 1);
by (assume_tac 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [conj_intr] 1);
by (assume_tac 1);
by (assume_tac 1);
result();

writeln"Reached end of file.";

(*21 August 88: loaded in 65 secs*)
