(*  Title: 	LK/set/subset
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Set theory: derived rules about the subset relation
    [ For interesting examples see directory ex ]

by (step_tac [triv_pack, LK_pack] 1);
by (step_tac [triv_pack, set_pack] 1);
by (step_tac [triv_pack, set_pack, ext_pack] 1);
*)



(*Reflexivity of subset relation*)
val subset_refl = prove_goal Set_Rule.thy
    "[| $H |- $E, A<=A, $F |]"
 (fn asms=>
  [ (set_tac 1) ]);


(*Least element for subset relation*)
val subset_null_right = prove_goal Set_Rule.thy
    "[| $H |- $E, 0<=A, $F |]"
 (fn asms=>
  [ (set_tac 1) ]);


(*Thinning of 0<=A on the left.
  Avoids subset_left, which would cause a needless case split.*)
val subset_null_left = prove_goal Set_Rule.thy
    "[| $H, $G |- $E |] ==> [| $H, 0<=A, $G |- $E |]"
 (fn asms=>
  [ (REPEAT (resolve_tac (thin_left::asms) 1)) ]);



(*Transitivity of subset relation.  Obviously cannot be used in auto proof.*)
val subset_trans = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, A<=B |] ==> [| $H |- $E, $F, B<=C |] ==> \
\    [| $H |- $E, A<=C, $F |]"
 (fn asms=>
  [ (cut_tac "A<=B" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "B<=C" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);



(*A special case of subset_right: introduces no equality assumptions. *)
val setcons_right_s = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, a : C |] ==> [| $H |- $E, $F, B <= C |] ==> \
\    [| $H |- $E, a::B <= C, $F |]"
 (fn asms=>
  [ (cut_tac "a : C" 1),    (*force choice of the correct assumption*)
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "B <= C" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (repeat_goal_tac [triv_pack, set_pack, ([eqmem_left_thin],[])] 1) ]);



(*A special case of subset_left: introduces no variables *)
val setcons_left_s = prove_goal Set_Rule.thy
    "[| $H, $G, a:C, B <= C |- $E |] ==> [| $H, a::B <= C, $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (resolve_tac [cut] 2),
    (thin_tac 3  THEN  resolve_tac asms 3),
    (set_tac 1),
    (set_tac 1) ]);



(* Union_right1_s.  B is new variable. *)
val Union_right1_s_thin = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, B:A |] ==> [| $H |- $E, $F, C<=B |] ==> \
\    [| $H |- $E, C <= Union(A), $F |]"
 (fn asms=>
  [ (cut_tac "B:A" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "C<=B" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


(*Proof involves cutting in an LK formula (not a premise).
  Previously most deriviations were like this.*)
val Union_right2_s = prove_goal Set_Rule.thy
    "(!(x)[| $H, x:A |- $E, $F, x<=C |]) ==> [| $H |- $E, Union(A) <= C, $F |]"
 (fn asms=>
  [ (cut_right_tac "ALL B. B:A --> B <= C" 1), 
    (setpc_tac 2),
    (REPEAT (resolve_tac (asms@[all_right,imp_right]) 1)) ]);



(* Union_left_s.  B is new variable.*)
val Union_left_s_thin = prove_goal Set_Rule.thy
    "[| $H, $G |- $E, B:A |] ==> [| $H, $G, B<=C |- $E |] ==> \
\    [| $H, Union(A) <= C, $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (thin_tac 1  THEN  resolve_tac asms 1),
    (resolve_tac [cut] 1),
    (thin_tac 2  THEN  thin_tac 2  THEN  resolve_tac asms 2),
    (set_tac 1) ]);


(* B is new variable.*)
val Inter_right1_s_thin = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, B:A |] ==> [| $H |- $E, $F, B<=C |] ==> \
\    [| $H |- $E, Inter(A) <= C, $F |]"
 (fn asms=>
  [ (cut_tac "B:A" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "B<=C" 1),   (*force choice of the correct assumption*)
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Inter_right2_s = prove_goal Set_Rule.thy
    "[| $H, A<=0 |- $E, $F |] ==> (!(x)[| $H, x:A |- $E, $F, C<=x |]) ==> \
\    [| $H |- $E, C <= Inter(A), $F |]"
 (fn asms=>
  [ (cut_right_tac "~ (A<=0) & ALL B. B:A --> C<=B" 1),
    (setpc_tac 2),
    (REPEAT (resolve_tac 
             (asms@[not_right,conj_right,all_right,imp_right]) 1)) ]);



(* B is new variable.

H, C <= Inter(A), $G |- $E, B:A      $H, C <= Inter(A), $G, C<=B |- $E    
-----------------------------------------------------------------
                   $H, C <= Inter(A), $G |- E
*)
val Inter_left_s_thin = prove_goal Set_Rule.thy
    "[| $H, $G |- $E, B:A |] ==> [| $H, $G, C<=B |- $E |] ==> \
\    [| $H, C <= Inter(A), $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (thin_tac 1  THEN  resolve_tac asms 1),
    (resolve_tac [cut] 1),
    (thin_tac 2  THEN  thin_tac 2  THEN  resolve_tac asms 2),
    (set_tac 1) ]);



(*Warning: this rule can lose information! *)
val Un_right1_s = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, C<=A, C<=B |] ==> [| $H |- $E, C <= A Un B, $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (resolve_tac [cut] 1),
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1),
    (set_tac 1) ]);


val Un_right2_s = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=C |] ==> [| $H |- $E, $F, B<=C |] ==> \
\    [| $H |- $E, A Un B <= C, $F |]"
 (fn asms=>
  [ (cut_tac "A<=C" 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "B<=C" 1),  
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Un_left_s = prove_goal Set_Rule.thy 
    "[| $H, $G, A<=C, B<=C |- $E |] ==> [| $H, A Un B <= C, $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (resolve_tac [cut] 2),
    (thin_tac 3  THEN  resolve_tac asms 3),
    (set_tac 1),
    (set_tac 1) ]);



(*Warning: this rule can lose information! *)
val Int_right1_s = prove_goal Set_Rule.thy
    "[| $H |- $E, $F, A<=C, B<=C |] ==> [| $H |- $E, A Int B <= C, $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (resolve_tac [cut] 1),
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1),
    (set_tac 1) ]);


val Int_right2_s = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, C<=A |] ==> [| $H |- $E, $F, C<=B |] ==> \
\    [| $H |- $E, C <= A Int B, $F |]"
 (fn asms=>
  [ (cut_tac "C<=A" 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "C<=B" 1),  
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Int_left_s = prove_goal Set_Rule.thy 
    "[| $H, $G, C<=A, C<=B |- $E |] ==> [| $H, C <= A Int B, $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (resolve_tac [cut] 2),
    (thin_tac 3  THEN  resolve_tac asms 3),
    (set_tac 1),
    (set_tac 1) ]);



(* M O N O T O N I C I T Y *)


val Collect_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=B |] ==> \
\    [| $H |- $E, Collect(A,P) <= Collect(B,P), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Replace_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=B |] ==> \
\    [| $H |- $E, Replace(f,A) <= Replace(f,B), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Pow_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=B |] ==> \
\    [| $H |- $E, Pow(A) <= Pow(B), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


val Union_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=B |] ==> \
\    [| $H |- $E, Union(A) <= Union(B), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1) ]);


(*Observe there are TWO premises! *)
val Inter_anti_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A<=B |] ==> [| $H, A<=0 |- $E, $F |] ==> \
\    [| $H |- $E, Inter(B) <= Inter(A), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),
    (thin_tac 1  THEN  resolve_tac asms 1),
    (resolve_tac [cut] 1),
    (thin_tac 2  THEN  thin_tac 2  THEN  resolve_tac asms 2),
    (set_tac 1) ]);


val setcons_mono = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, a=b |] ==> [| $H |- $E, $F, C<=D |] ==> \
\    [| $H |- $E, a::C <= b::D, $F |]"
 (fn asms=>
  [ (cut_tac "a=b" 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (cut_tac "C<=D" 1),  
    (thin_tac 1  THEN  thin_tac 1  THEN  resolve_tac asms 1),
    (set_tac 1),
    (reresolve_tac [basic,trans] 1) ]);


(*Monotonicity rules must be early 
  -- they are more specific than others; would otherwise never be reached.  
  Most of them lose information. *)


val subset_pack =
   ([subset_null_right, subset_refl, setcons_right_s,
     Pow_mono, 
     Union_mono, 
     setcons_left_s, Union_right2_s, Inter_right2_s, 
     Un_right2_s, Un_left_s, Int_right2_s, Int_left_s, equal_left_s],
    [subset_null_left, 
     Collect_mono, Replace_mono, Inter_anti_mono, setcons_mono, 
     Un_right1_s, Int_right1_s, 
     Union_right1_s_thin, Union_left_s_thin,
     Inter_right1_s_thin, Inter_left_s_thin]);



val subset_tac = repeat_goal_tac [triv_pack, subset_pack];

val subsetpc_tac =
    repeat_goal_tac [triv_pack, subset_pack, LK_pack];



(*Powerset is one-to-one*)

val Pow_eq_left = prove_goal Set_Rule.thy 
    "[| $H, $G, A=B |- $E |] ==> \
\    [| $H, Pow(A) = Pow(B), $G |- $E |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 2  THEN  resolve_tac asms 2),
    (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1) ]);


(*Congruence = both directions of monotonicity*)
val Pow_eq_right = prove_goal Set_Rule.thy 
    "[| $H |- $E, $F, A=B |] ==> \
\    [| $H |- $E, Pow(A) = Pow(B), $F |]"
 (fn asms=>
  [ (resolve_tac [cut] 1),  
    (thin_tac 1  THEN  resolve_tac asms 1),
    (repeat_goal_tac [triv_pack, subset_pack, ext_pack] 1) ]);

