(*  Title: 	HOL/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Adds Classical Higher-order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory HOL.

To build system, enter Poly/ML and type
    PolyML.use "ROOT.ML";
*)

writeln"Root file for Classical Higher-order Logic";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "lemmas.ML";
use "prover.ML";

print_depth 0;  
structure HOL_Syntax = HOL_SyntaxFun
    (structure Syntax=Syntax and Pretty=Pretty);
structure HOL_Rule = HOL_RuleFun(structure HOL_Syntax=HOL_Syntax and Thm=Thm);
structure HOL_Lemmas = HOL_LemmasFun
    (structure HOL_Syntax=HOL_Syntax and HOL_Rule=HOL_Rule
	   and Logic=Logic and Conv=Conv);

open Thm Tactic Goals Conv;
open HOL_Syntax HOL_Rule HOL_Lemmas;
print_depth 1;  

Unify.printer := Syntax.prin syn;

(*Creation of theorem provers using functor ProverFun.*)
use "class.ML";
commit();

use "simp.ML";
use "types.ML";
use "tarski.ML";
use "wf.ML";
use "arith.ML";
use "list.ML";

(*Creation of simplifier*)
use "rew.ML";

print_depth 8;  
                
