    (["cond"],          [Atype,Aterm,Aterm,Aterm]--->Aterm),

    ("cond_def",
        "cond(A,p,a,b) == PICK x:A.(form(p)  & [x=a:A]) | \
\                                  (~form(p) & [x=b:A])" ),



(** Conditionals -- thanks to Martin Coen **)

val cond_type = prove_goal HOL_Rule.thy 
     "([| form(p)  |] ==> [| a:A |]) ==> \
\     ([| ~form(p) |] ==> [| b:A |]) ==> \
\     [| cond(A,p,a,b) : A |]"
 (fn asms=>
  [ (rewrite_goals_tac [cond_def]),
    (resolve_tac [Pick_type] 1),
    (resolve_tac [disj_elim] 1),
    (resolve_tac [ex_middle] 1),
    (resolve_tac [exists_intr] 1),
    (resolve_tac [disj_intr2] 1),
    (REPEAT (ares_tac (asms@[conj_intr,refl,exists_intr,disj_intr1]) 1)) ]);

val cond_convT = prove_goal HOL_Rule.thy 
     "[| a:A |] ==> \
\     [| [cond(A,True,a,b)=a:A] |]"
 (fn asms=>
  [ (rewrite_goals_tac [cond_def]),
    (resolve_tac [Pick_iff_equals] 1),
    (Pc.tp_tac asms),
    (REPEAT (ares_tac [True_intr,contr_elim] 1)) ]);

val cond_convF = prove_goal HOL_Rule.thy 
     "[| b:A |] ==> \
\     [| [cond(A,False,a,b)=b:A] |]"
 (fn asms=>
  [ (rewrite_goals_tac [cond_def]),
    (resolve_tac [Pick_iff_equals] 1),
    (Pc.tp_tac asms),
    (REPEAT (ares_tac [not_intr,contr_elim] 1)) ]);

