(*  Title: 	CTT/ex/typechk
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge
  
Easy examples: type checking and type deduction
*)


writeln"Single-step proofs: verifying that a type is well-formed";

goal CTT_Rule.thy "[|?A type|]";
by (resolve_tac form_rls 1);
uresult(); 
writeln"getting a second solution";
back();
by (resolve_tac form_rls 1);
by (resolve_tac form_rls 1);
uresult(); 



goal CTT_Rule.thy "[| PROD x:?A. N + ?B(x) type |]";
by (resolve_tac form_rls 1);
by (resolve_tac form_rls 1);
by (resolve_tac form_rls 1);
by (resolve_tac form_rls 1);
by (resolve_tac form_rls 1);
uresult(); 




writeln"Multi-step proofs: Type inference";

goal CTT_Rule.thy "[| PROD x:N. N + N type |]";
by form_tac;
uresult(); 


goal CTT_Rule.thy "[| <0, succ(0)> : ?A |]";
by (intr_tac[]);
by (rewrite_tac [symmetric Times_def]);
uresult(); 



goal CTT_Rule.thy "[| PROD x:N . Eq(?A,x,x) type |]";
by (typechk_tac[]);
uresult(); 


goal CTT_Rule.thy "[| PROD x:N . PROD y:N . Eq(?A,x,y) type |]";
by (typechk_tac[]);
uresult(); 


writeln"typechecking an application of fst";
goal CTT_Rule.thy "[| (lam x. split(x, %(y,z)y)) ` <0, succ(0)> : ?A |]";
by (typechk_tac[]);
uresult(); 


writeln"typechecking the predecessor function";
goal CTT_Rule.thy "[| lam n. rec(n, 0, %(x,y)x) : ?A |]";
by (typechk_tac[]);
by (rewrite_tac [symmetric Fun_def]);
uresult(); 


writeln"typechecking the addition function";
goal CTT_Rule.thy "[| lam n. lam m. rec(n, m, %(x,y)succ(y)) : ?A |]";
by (typechk_tac[]);
by (rewrite_tac [symmetric Fun_def]);
uresult(); 


(*Proofs involving arbitrary types.
  For concreteness, every type variable left over is forced to be N*)
val N_tac = TRYALL (resolve_tac [N_form]);


goal CTT_Rule.thy "[| lam x. <x,x> : ?A |]";
by (typechk_tac[]);
by N_tac;
by (rewrite_tac [symmetric Fun_def, symmetric Times_def]);
uresult(); 


goal CTT_Rule.thy "[| lam x. lam y. x : ?A |]";
by (typechk_tac[]);
by N_tac;
by (rewrite_tac [symmetric Fun_def]);
uresult(); 


writeln"typechecking fst (as a function object) ";
goal CTT_Rule.thy "[| lam x. split(x, %(y,z)y) : ?A |]";
by (typechk_tac[]);
by N_tac;
by (rewrite_tac [symmetric Fun_def, symmetric Times_def]);
uresult(); 

writeln"Reached end of file.";

(*28 August 1988: loaded this file in 14 seconds*)
(*2 September 1988: loaded this file in 15 seconds*)
