(*  Title: 	tt-ex-synth
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

writeln"Synthesis examples, using a crude form of narrowing";


writeln"This finds the functions fst and snd ?";
read_goal TypeThy "?a : N*N ==> N";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (resolve_tac elim0_rls 1);
expand (depth_assume_tac THEN form_tac);
writeln"first solution is snd;  backtracking gives fst";
backtrack();
writeln"and there are no other solutions";
backtrack();
{ expand (depth_assume_tac THEN form_tac THEN fold_tac ["fst","snd"]);  }


writeln"discovery of predecessor function";
read_goal TypeThy 
 "?a : SUM pred:?A .	Eq(N, pred`0, 0)	\
\		     *	PROD n:N. Eq(N, pred ` succ(n), n)";
expand (unfold_goal_tac ["*"]);
expand intr_tac;
expand eqintr_tac;
expand (resolve_tac reduction_rls 3);
expand (resolve_tac comp_rls 5);
expand (resolve_tac reduction_rls 2);
expand (resolve_tac comp_rls 4);
expand typechk_tac;



writeln"the function fst as an element of a function type";
read_goal TypeThy 
 "?a : SUM f : ?A . PROD i:N. PROD j:N. Eq(N, f ` <i,j>, i)";
expand intr_tac;
expand eqintr_tac;
expand (resolve_tac reduction_rls 2);
expand (resolve_tac comp_rls 4);
expand typechk_tac;
writeln"now put in N everywhere";
expand (determ_resolve_tac ([N_form], 1));



(*a more interesting use of WHEN.
 Early implementation of unification caused non-rigid path in occur check
 See following example.*)
read_goal TypeThy 
 "?a : PROD i:N. Eq(?A, ?b'(inl(i)), <0    ,   i>)  \
\  	       * Eq(?A, ?b'(inr(i)), <succ(0), i>) ";
expand (unfold_goal_tac ["*"]);
expand intr_tac;
expand eqintr_tac;
expand (resolve_tac comp_rls 1);
expand (resolve_tac comp_rls 4); 
expand typechk_tac;
expand (fold_tac ["*"]);


(*Here we allow the type to depend on i.  
 This prevents the cycle in the first unification (no longer needed).  
 Requires flex-flex to preserve the dependence.
 Simpler still: make ?A into a constant type N*N.*)
read_goal TypeThy 
 "?a : PROD i:N. Eq(?A'(i), ?b'(inl(i)), <0   ,   i>)   \
\ 	      *  Eq(?A'(i), ?b'(inr(i)), <succ(0),i>) ";



(*a hard use of WHEN and SPLIT -- combining eliminators.
  Now handled easily, but caused great problems once*)
read_goal TypeThy 
 "?a : PROD i:N. PROD j:N. Eq(?A, ?b'(inl(<i,j>)), i)   \
\  	    	        *  Eq(?A, ?b'(inr(<i,j>)), j) ";
expand (unfold_goal_tac ["*"]);
expand intr_tac; 
expand eqintr_tac;
expand (resolve_tac [ trans_elem RES Plus_comp_inl ] 1);
expand (resolve_tac comp_rls 4); 
expand (resolve_tac reduction_rls 7);
expand (resolve_tac comp_rls 10);
expand typechk_tac; (*2 secs*)
expand (determ_resolve_tac ([N_form], 1));



(*similar but allows the type to depend on i and j*)
read_goal TypeThy 
 "?a : PROD i:N. PROD j:N. Eq(?A''(i,j), ?b'(inl(<i,j>)), i) \
\ 	    	       *   Eq(?A''(i,j), ?b'(inr(<i,j>)), j) ";

(*similar but specifying the type N makes it much easier*)
read_goal TypeThy
 "?a : PROD i:N. PROD j:N. Eq(N, ?b'(inl(<i,j>)), i)	\
\ 	    	       *   Eq(N, ?b'(inr(<i,j>)), j) ";




(*"add" as an operator*)
read_goal TypeThy 
  "?c : PROD n:N. Eq(N, ?a''(0,n), n)  \
\  	        *  PROD m:N. Eq(N, ?a''(succ(m), n), succ(?a''(m,n)))";
expand (unfold_goal_tac ["*"]);
expand intr_tac;
expand eqintr_tac;
expand (resolve_tac comp_rls 1);
expand (resolve_tac comp_rls 3);
expand typechk_tac;



read_goal TypeThy 
  "?c : SUM plus : ?A .  \
\  	 PROD x:N. Eq(N, plus`0`x, x)  \
\  	        *  PROD y:N. Eq(N, plus`succ(y)`x, succ(plus`y`x))";
expand (unfold_goal_tac ["*"]);
expand intr_tac;
expand eqintr_tac;
expand (resolve_tac [ trans_elem RES Prod_elim_long ] 3);
    expand (resolve_tac [refl_elem] 4);
expand (resolve_tac comp_rls 3);
expand (resolve_tac reduction_rls 6);
expand (resolve_tac [transym_elem] 8);
expand (resolve_tac intr_long_rls 8);
expand (resolve_tac [ trans_elem RES Prod_elim_long ] 8);
    expand (resolve_tac [refl_elem] 9);
expand (resolve_tac comp_rls 8);
expand (resolve_tac comp_rls 11);
expand (resolve_tac comp_rls 13);
expand (resolve_tac [ trans_elem RES Prod_elim_long ] 2);
    expand (resolve_tac [refl_elem] 3);
expand (resolve_tac comp_rls 2);
expand (resolve_tac reduction_rls 5);
expand (resolve_tac comp_rls 7);
expand typechk_tac;
expand (fold_tac ["#+"]);


