(*  Title: 	tt-ex-elim
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*Examples for elimination rules*)



read_goal TypeThy "?a : (A*A) ==> A  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand elintr_tac;
backtrack(); 


read_goal TypeThy "?a : (A*B) ==> (B*A)  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand elintr_tac;
backtrack();
(*an interesting alternative?*)


read_goal TypeThy "?a : (A+B ==> C) ==> (A==>C) * (B==>C)  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 1 7);
expand (elim_hyp_tac 1 5);  (*inner hypothesis, so elintr doesn't find it*)
(*wider bound allows choice between inl and inr in search*)
expand (depth_resolve_tac (elem_choose(intr_rls@assume_rls, 4))); (*3 secs*)
expand form_tac;


(*non-thinning version of elintr diverges:
    the hyp B+C is found again when searching for hypotheses*)
read_goal TypeThy "?a : A * (B+C)  ==>  (A*B + A*C)  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand (depth_resolve_tac (elem_choose(elintr_rls @ assume_rls, 5))
	THEN form_tac); 
(*3 secs*)


(*more general version, same proof*)
read_goal TypeThy "?a : (SUM x:A. B'(x) + C'(x)) \
\                   ==>  (SUM x:A. B'(x)) + (SUM x:A. C'(x))  [ H ]";




read_goal TypeThy "?a : (A*B ==> C) ==> (A==> (B==>C))  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 2 6);             (*so can't use elintr*)
expand intr_tac;
expand (determ_assume_tac THEN merge_premises_tac);

(*more general goal with same proof*)
read_goal TypeThy "?a : (PROD z : (SUM x:A . B'(x)) . C'(z)) \
\                      ==> (PROD x:A . PROD y:B'(x) . C'(<x,y>))  [ H ]";



(*Martin-Lof (1984), page 48: axiom of sum-elimination*)
read_goal TypeThy "?a : (A==> (B==>C)) ==> (A*B ==> C)  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (resolve_tac elim0_rls 6);
expand (elim_hyp_tac 2 8);             (*so can't use elintr*)
expand elintr_tac;  

(*more general goal with same proof*)
read_goal TypeThy "?a : (PROD x:A . PROD y:B'(x) . C'(<x,y>)) \
\                      ==> (PROD z : (SUM x:A . B'(x)) . C'(z))  [ H ]";



read_goal TypeThy "?a : ((A ==> B) * A) ==> B  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 0 4);
expand (elim_hyp_tac 1 5);            (*so can't use elintr*)
expand determ_assume_tac;

(*Permuting the goal makes all eliminations refer to the last hyp*)
read_goal TypeThy "?a : (A * (A ==> B)) ==> B  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand elintr_tac;  


(*Most basic test of quantifier reasoning
  It seems impossible to avoid eliminating an inner hyp, 
  so elintr can not solve this alone.*)
read_goal TypeThy "?a : (SUM y:B . PROD x:A . C''(x,y))  \
\                   ==>  (PROD x:A . SUM y:B . C''(x,y))  [ H ]";
expand (unfold_goal_tac ["==>"]);
expand (resolve_tac intr_rls 1);
expand (resolve_tac intr_rls 2);
expand (elim_hyp_tac 1 3);    (*must eliminate before further introductions?*)
expand elintr_tac;  

(*faulty proof attempt, stripping the quantifiers in wrong sequence
expand (unfold_goal_tac ["==>"]);
expand intr_tac;
expand (elim_hyp_tac 1 6);
expand (resolve_tac [Prod_elim0] 7);  
    ...fails!!  parameter dependencies forbid using the hypotheses *)



(*Martin-Lof (1984) pages 36-7: the combinator S*)
read_goal TypeThy "?a : (PROD x:A. PROD y:B'(x). C''(x,y)) \
\                  ==> (PROD f: (PROD x:A. B'(x)). PROD x:A. C''(x, f`x))  [ H ]";
expand (unfold_goal_tac ["==>"]);
expand intr_tac;
expand (elim_hyp_tac 2 7);
expand (elim_hyp_tac 0 9);
expand typechk_tac;


(*Martin-Lof (1984) page 58: the axiom of disjunction elimination
  note subgoals  C'(inl(x)) type and C'(inr(y)) type?
  Martin-Lof has instead   C'(z) type [ z : A+B ]
  requires categories??  *)
read_goal TypeThy
  "?a : (PROD x:A. C'(inl(x))) ==> (PROD y:B. C'(inr(y)))  \
\                      ==> (PROD z: A+B. C'(z))  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 0 7);
expand (elim_hyp_tac 3 8);
expand (elim_hyp_tac 2 10);
expand intr_tac;
expand determ_assume_tac;



(*  ?p : Sum(?A,?B'1) [ ?H ]     ?A type [ ?H ]     
    -------------------------------------------
	fst(?p) : ?A [ ?H ]           *)
read_goal TypeThy "fst(p) : A [H]";
expand (unfold_goal_tac ["fst"]);
expand (determ_resolve_tac (elim_rls@assume_rls,3));
val Sum_elim_fst = tidyrule(top_rule());

val Sum_elim0_fst = resolvelist(Sum_elim_fst,
                  [ (1, [assume_elem]), (1, form_rls)] );



(*deriving SND  
p : SUM u:?A. B'(u) [H]     ?A type [H]     B'(s1) type [ H, s1: ?A ]
------------------------------------------------------------------------------
               snd(p) : B'(fst(p)) [H] 
  must collapse many repeated premises?*)
read_goal TypeThy "snd(p) : B'(fst(p)) [H]";
expand (unfold_goal_tac ["fst","snd"]);
expand (resolve_tac elim_rls 1);
expand (rconstrain_tac [ ("?A","A"), ("?B'","B'") ]);
expand (resolve_tac [equalsym_types] 2);
expand (resolve_tac [subst_eqtyparg] 3);   (*like a B(x) equality formation?*)
expand (resolve_tac comp_rls 3);
expand determ_assume_tac;
val sum_elim_snd = tidyrule(top_rule());


val Sum_elim0_snd = resolvelist(sum_elim_snd,
                  [ (1, [assume_elem]), (1, form_rls)] );



(*towards AXIOM OF CHOICE*)
read_goal TypeThy "?a : (A ==> B*C) ==> (A==>B) * (A==>C)  [ H ]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 1 5);
expand (resolve_tac [Sum_elim0] 7);    (*creates "fst" *)
expand (elim_hyp_tac 1 11);
expand (resolve_tac [Sum_elim0] 13);   (*creates "snd" *)
expand determ_assume_tac;


(*AXIOM OF CHOICE ???
  Delicate use of elimination;  
  subst_prod_elim followed by Sum_elim0 seems to be the key step *)
read_goal TypeThy "?a : (PROD x:A. SUM y:B'(x). C''(x,y)) \
\            ==> (SUM f: (PROD x:A. B'(x)). PROD x:A. C''(x, f`x))  [H]";
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 1 5);
expand (resolve_tac [Sum_elim0_fst] 7);
expand (resolve_tac [equalsym_types] 11);
expand (resolve_tac [subst_eqtyparg] 12);
  (*was expand (resolve_tac subst_rls 12);expand (resolve_tac [refl_type] 13);*)
expand (resolve_tac comp_rls 12);
expand (elim_hyp_tac 1 11);
expand (resolve_tac [Sum_elim0_snd] 13);
expand (resolve_tac [Sum_elim_fst] 20);
expand typechk_tac;
expand merge_premises_tac;


(*Proof without fst, snd: derives sum_elim_snd in-line*) 
expand (unfold_goal_tac ["*","==>"]);
expand intr_tac;
expand (elim_hyp_tac 1 5);
expand (resolve_tac [Sum_elim0] 7);
expand (SELECT_GOAL determ_assume_tac 9);
expand (resolve_tac [equalsym_types] 11);
expand (resolve_tac [subst_eqtyparg] 12);
expand (resolve_tac comp_rls 12);
expand (elim_hyp_tac 1 11);
expand (resolve_tac [Sum_elim0] 13);
expand (resolve_tac [equalsym_types] 15);
expand (resolve_tac [subst_eqtyparg] 16);
expand (resolve_tac comp_rls 16);
expand typechk_tac; (*3 secs*)
expand determ_assume_tac;
expand (fold_tac ["fst","snd"]);


(*Experiment on sequent_style deduction.
  When splitting z:A*B, the assumption C(z) is affected.
  Final construction ?a is
    lam u. split(u,%(v,w)split(v,%(x,y)lam z. <x,<y,z>>) ` w)
*)
read_goal TypeThy
    "?a : (SUM z:A*B. C'(z)) ==> SUM x:A. SUM y:B. C'(<x,y>)  [H]";
expand (unfold_goal_tac ["*","==>"]);
expand (resolve_tac intr_rls 1);
expand (resolve_tac elim0_rls 2);
(*Convert assumption C'(x3) into C'(<x12,y12>) 
  otherwise proof fails*)
expand (resolve_tac [Prod_elim] 4);
expand (resolve_tac [assume_elem] 5);
expand (resolve_tac [Sum_elim  RES  thin_elem  RES  assume_elem ] 4);
expand intr_tac;
expand determ_assume_tac;
