(*  Title: 	match
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   Cambridge University 1986
*)

(*One way unification -- Matching*)

(*One-way simplification: variables can be instantiated in t but not u*)
fun ONESIM0 (dp0, (env,dpairs)) : envir * dpair list =
  let val dp as (rbinder,t,u) = head_norm_dpair(env,dp0);
      fun SIMRANDS (ratort$randt, ratoru$randu) =
	    ONESIM0 ((rbinder,randt,randu), SIMRANDS(ratort,ratoru))
	| SIMRANDS _ = (env,dpairs);
      fun ONESIM_IF true = SIMRANDS(t,u)
        | ONESIM_IF false = raise unify
  in
  if alphaconv (t,u) then (env,dpairs)
  else case (head_of t, head_of u) of
       (Var(uname,_), _) => 
	  (case fixedpoint (env,rbinder,t,u) of
	 	Some env' => (env', dpairs)
	      | None      => (env, dp::dpairs))
     | (Const(idt,_), Const(idu,_)) => ONESIM_IF (idt=idu)
     | (Bound bnt,    Bound bnu)    => ONESIM_IF (bnt=bnu)
     | (Param(idt,_), Param(idu,_)) => ONESIM_IF (idt=idu)
     | _ => raise unify
  end;


(*Recursion needed if any 'head variables' have been updated*)
fun ONESIM (env,dpairs) : envir * dpair list =
  let val (env',dpairs') = itlist_right ONESIM0 (dpairs, (env,[]))
  in  if exists (fn ((_,t,u)) => changed(env',t)) dpairs' 
	then  ONESIM (env',dpairs')   else (env',dpairs')
  end;


(*code taken from matchcopy;  
  does it need to consider all possible matches?*)
fun mamatchcopy (tname, rbinder, targs, u, ed as (env,dpairs)) 
  : (term * (envir * dpair list)) list =
  let fun copycons uarg (uargs, (env, dpairs)) = 
	    map (fn (uarg', ed') => (uarg'::uargs, ed'))
		(mamatchcopy (tname, rbinder, targs,  
			eta_norm(rbinder, head_norm(env,uarg)),
			(env, dpairs)));
      fun copyargs [] = [ ([],ed) ]
	| copyargs (uarg::uargs) =
	    flat (map (copycons uarg) (copyargs uargs));
      val (uhead,uargs) = strip_comb u;
      fun joinargs (uargs',ed') = (list_comb(uhead,uargs'), ed');
     (*attempt projection on argument with given arity*)
      val base = body_arity (fastarity (rbinder,uhead));
      val tarys = map (curry fastarity rbinder) targs;
      fun projenv (head, (arys,bary), targ) = 
        if base=bary  then 
	  let val (env',args) = make_args (tarys,env,arys);
	      val dp = (rbinder, list_comb(targ,args), u);
	      val (env2,dpairs2) = ONESIM (env', dp::dpairs)
		  (*may raise exception unify*)
	  in  [ (list_comb(head,args), (env2, dpairs2)) ]  end
	  handle unify => []
        else [];
      (*try projections*)
      fun PROJFUN (ary::arys, targ::targs) =
	    projenv(Bound(length arys), strip_arity ary, targ)
	    @ PROJFUN(arys,targs) 
       	| PROJFUN ([], []) = (*try imitation*)
	    (case uhead of
	       Const _ => map joinargs (copyargs uargs)
	     | Var (uname,_) => 
		  if uname=tname then []  (*loop detected!*)
		  else  map joinargs (copyargs uargs)
	     | Param (pname,_)  =>
		  if occurs_terms (ref[],env,tname,depslookup(env,pname))
		  then []   
		  else map joinargs (copyargs uargs)
	     | _ => [])
     	| PROJFUN _ = raise term_error with ("PROJFUN", u::targs)
  in  case head_of u  of
	  Abs(name, ary, body) =>
	    map (fn (body', ed') => (Abs (name,ary,body'), ed')) 
		(mamatchcopy (tname, (name,ary)::rbinder, 
			(map (incr_boundvars 1) targs) @ [Bound 0],
			body, ed))
        | _ =>  PROJFUN(tarys, targs)
  end;



fun MAMATCH (env, (rbinder,t,u), dpairs) : (envir * dpair list) list = 
  let val (Var(tname,tary), targs) = strip_comb t;
      val tarys = binder_arities tary;
      fun new_dset (u', (env',dpairs')) =
	    (eupdate ((tname, arities_abs(tarys, u')), env'),   dpairs')
  in  map new_dset (mamatchcopy (tname, rbinder, targs, u, (env,dpairs)))
  end;



(*find environment that matches the (t,u) dpairs,
  	only trying to instantiate variables in t 
  The rbinder is used for matching inside a term.*)
fun matcher (env, rbinder, tus: (term*term)list) : envir =
  let fun matchloop (env,dpairs) =
      case ONESIM (env,dpairs) of
	  (env',[])    =>  env'
	| (env', dp::dpairs') => 
	      let fun mtry [] = raise unify
		    | mtry ((env2,dpairs2) :: eds) =
			matchloop (env2, dpairs2)  handle unify => mtry eds
	      in mtry (MAMATCH (env', dp, dpairs'))
	      end
  in matchloop (env, map (fn(t,u)=> (rbinder,t,u)) tus)  end;





fun tmatch sign (env, tus: (term*term) list) : unit =
  let val ppairs = seq (print_tpair sign);
      val env' = matcher (env,[],tus)
  in  ppairs (normpairs env' tus);  print_env sign env'  end;


(*Test unification with parsed terms of signature*)
fun tmatch_read sign (spairs: (string*string) list) =
  tmatch sign (null_env, map (read_termpair sign) spairs);


(*if exactly one match of pattern to object then replace*)
fun trymatch(env, rbinder, object, pattern, replacement) : term =
  norm_term (matcher(env, rbinder, [ (pattern,object) ])) replacement;


(*prepare a definition for folding:
 	generate variables to form terms of ground arity.
  The rbinder allows bound variables in the match. *)
fun prepare_fold binder ((id,rhs), (env, rews)) =
  let val ary = arity_of rhs;
      val (barys,aname) = strip_arity ary;
      val (env', vars) = make_args (binder, env, barys);
      val rew = (aname, list_comb(rhs,vars), list_comb(Const(id,ary), vars))
  in  (env', rew::rews)  end;


(*apply a list of rewrites to the term
  Each rewrite is a pattern and replacement of some Ground arity "aname"
  rbinder allows computation of arities of subterms*)
fun rewrite_term (maxidx,rbinder,defines) =
  let val env0 = Envir{maxidx= maxidx, asol= null_olist, depol= null_olist};
      val binder = rev (map snd rbinder);
      val (env,rews) = itlist_right (prepare_fold binder) (defines, (env0,[]));
      fun rewrands (rator$rand) = rewrands rator $ rewrite rand
	| rewrands tm = tm
      and trymatches(tm,aname,retry) =
	    let fun trym [] = if retry
			      then trymatches(rewrands tm, aname, false)
			      else tm
	          | trym ((anamei,pati,repi)::rews') =
	              if aname=anamei then 
		          trymatches(trymatch(env,rbinder,tm,pati,repi),
				     aname, true)
		          handle unify => trym rews'
	              else trym rews'
	    in  trym rews  end
      and rewrite tm =
	    case fastarity(rbinder,tm) of
	        Ground aname => trymatches (tm,aname,true)
	      | _ => (*function arity, try certain subterms*)
	         (case tm of
	  	    Abs(id,ary,body) =>
			Abs(id, ary, rewrite_term (maxidx, (id,ary)::rbinder,
					defines) body)
	  	  | _$_ => rewrands tm
	  	  | _ => tm)
  in  rewrite  end;




(*fold a term using the given definitions*)
fun fold_term (maxidx,defines,tm) : term =
  norm_term null_env (rewrite_term (maxidx,[],defines) tm);



(*Repeated substitution of terms for constants.
  Does NOT check that constants are distinct!  The terms must be closed *)
fun unfold_term ([]     : (string*term) list, tm) = tm
  | unfold_term (defines: (string*term) list, tm) =
  let fun subst tm = case tm of
	Const (id,_) => 
	  (case sassoc(defines,id) of  None => tm  |  Some tm' => subst tm') 
      | Param _ => tm
      | Bound _ => tm
      | Var _ => tm
      | Abs(name,ary,body) => Abs(name, ary, subst body)
      | rator $ rand => subst rator  $  subst rand 
  in  subst tm  end;


